/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.CompiledOpenClass;
import org.openl.base.INamedThing;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.AOpenIterator;
import org.openl.util.ASelector;
import org.openl.util.AStringConvertor;
import org.openl.util.ArrayTool;
import org.openl.util.ISelector;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;
import org.openl.util.generation.JavaClassGeneratorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWrapperGenerator {
    private String targetClass;
    private String extendsClass = null;
    private String[] implementsInterfaces;
    private String openlName;
    private String deplSrcFile;
    private String srcFile;
    private String srcModuleClass;
    private String userHome = ".";
    private String deplUserHome;
    private String rulesFolder;
    private String[] fields;
    private String[] methods;
    private boolean ignoreNonJavaTypes;
    private IOpenClass moduleOpenClass;
    private String s_class;
    private String s_package;
    private static String resName = "__res";
    private StringBuffer initBuf = new StringBuffer(1000);
    private List<String> defaultImports;
    private List<String> methodImports;

    public JavaWrapperGenerator(String targetClass, String extendsClass, String[] implementsInterfaces, String openlName, String deplSrcFile, String srcFile, String srcModuleClass, String userHome, String deplUserHome, String rulesFolder, String[] fields, String[] methods, boolean ignoreNonJavaTypes) {
        this.targetClass = targetClass;
        this.extendsClass = extendsClass;
        if (implementsInterfaces != null) {
            this.implementsInterfaces = (String[])implementsInterfaces.clone();
        }
        this.openlName = openlName;
        this.deplSrcFile = deplSrcFile;
        this.srcFile = srcFile;
        this.srcModuleClass = srcModuleClass;
        this.userHome = userHome;
        this.deplUserHome = deplUserHome;
        this.rulesFolder = rulesFolder;
        if (methods != null) {
            this.methods = (String[])methods.clone();
        }
        if (fields != null) {
            this.fields = (String[])fields.clone();
        }
        this.ignoreNonJavaTypes = ignoreNonJavaTypes;
        this.initImports();
    }

    private void initImports() {
        this.defaultImports = new ArrayList<String>();
        this.defaultImports.add("java.util.Map");
        this.defaultImports.add("org.openl.types.IOpenClass");
        this.defaultImports.add("org.openl.conf.IUserContext");
        this.defaultImports.add("org.openl.conf.UserContext");
        this.defaultImports.add("org.openl.impl.OpenClassJavaWrapper");
        this.defaultImports.add("org.openl.source.IOpenSourceCodeModule");
        this.methodImports = new ArrayList<String>();
        this.methodImports.add("org.openl.util.Log");
        this.methodImports.add("org.openl.util.RuntimeExceptionWrapper");
        this.methodImports.add("org.openl.types.java.OpenClassHelper");
    }

    public String generateJavaClass(IOpenClass moduleOpenClass) {
        this.moduleOpenClass = moduleOpenClass;
        StringBuffer buf = new StringBuffer(10000);
        this.parseClassName();
        this.addComment(buf);
        this.addPackage(buf);
        this.addImports(moduleOpenClass, buf);
        this.addClassDeclaration(buf);
        this.addInnerFields(buf);
        this.addEnvVariable(buf);
        this.addRuntimeContextProvider(buf);
        this.addRuntimeContextConsumer(buf);
        this.addConstructorWithParameter(buf);
        this.addFieldMethods(moduleOpenClass, buf);
        this.addMethods(moduleOpenClass, buf);
        this.addInitMethod(buf);
        buf.append("}");
        return buf.toString();
    }

    private void parseClassName() {
        int idx = this.targetClass.lastIndexOf(46);
        if (idx < 0) {
            this.s_class = this.targetClass;
        } else {
            this.s_package = this.targetClass.substring(0, idx);
            this.s_class = this.targetClass.substring(idx + 1, this.targetClass.length());
        }
    }

    private void addComment(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getCommentText((String)"This class has been generated. Do not change it, if you need to modify functionality - subclass it"));
    }

    private void addEnvVariable(StringBuffer buf) {
        buf.append("  private ThreadLocal<org.openl.vm.IRuntimeEnv> __env = new ThreadLocal<org.openl.vm.IRuntimeEnv>(){\n").append("    @Override\n").append("    protected org.openl.vm.IRuntimeEnv initialValue() {\n").append("      org.openl.vm.IRuntimeEnv environment = new org.openl.vm.SimpleVM().getRuntimeEnv();\n").append("      environment.setContext(new org.openl.rules.context.DefaultRulesRuntimeContext());\n").append("      return environment;\n").append("    }\n").append("  };\n\n");
        buf.append("  public org.openl.vm.IRuntimeEnv getRuntimeEnvironment() {\n    return __env.get();\n  }\n\n  public void setRuntimeEnvironment(org.openl.vm.IRuntimeEnv environment) {\n    __env.set(environment);\n  }\n\n");
    }

    private void addRuntimeContextProvider(StringBuffer buf) {
        buf.append("  public org.openl.rules.context.IRulesRuntimeContext getRuntimeContext() {\n");
        buf.append("    return (org.openl.rules.context.IRulesRuntimeContext)getRuntimeEnvironment().getContext();\n");
        buf.append("  }\n\n");
    }

    private void addRuntimeContextConsumer(StringBuffer buf) {
        buf.append("  public void setRuntimeContext(org.openl.rules.context.IRulesRuntimeContext context) {\n");
        buf.append("    getRuntimeEnvironment().setContext(context);\n");
        buf.append("  }\n\n");
    }

    private void addFieldAccessor(IOpenField field, StringBuffer buf) {
        IOpenClass type = field.getType();
        String className = this.getClassName(type.getInstanceClass());
        buf.append("\n  public ").append(className).append(" get").append(this.fieldMethodPart(field)).append("()").append("\n  {\n").append("   Object ").append(resName).append(" = ").append(this.getFieldFieldName(field)).append(".get(__instance, __env.get());\n").append("   return ").append(this.castAndUnwrap(type.getInstanceClass(), resName)).append(";\n").append("  }\n\n");
    }

    private void addClassDeclaration(StringBuffer buf) {
        String classDeclaration = null;
        classDeclaration = this.extendsClass != null ? JavaClassGeneratorHelper.addExtendingClassDeclaration((String)this.s_class, (String)this.extendsClass) : JavaClassGeneratorHelper.getSimplePublicClassDeclaration((String)this.s_class);
        if (this.implementsInterfaces != null) {
            buf.append(JavaClassGeneratorHelper.addImplementingInterfToClassDeclaration((String)classDeclaration, (String[])this.implementsInterfaces));
        }
        buf.append("\n{\n");
    }

    private void addFieldMethods(IOpenClass moduleOpenClass, StringBuffer buf) {
        for (IOpenField field : moduleOpenClass.getFields().values()) {
            if (!this.isFieldGenerated(field)) continue;
            this.addFieldFieldInitializer(field);
            this.addFieldField(field, buf);
            this.addFieldAccessor(field, buf);
            this.addFieldModifier(field, buf);
        }
    }

    private void addMethods(IOpenClass moduleOpenClass, StringBuffer buf) {
        for (IOpenMethod method : moduleOpenClass.getMethods()) {
            if (!this.isMethodGenerated(method)) continue;
            this.addMethodFieldInitializer(method);
            this.addMethodField(method, buf);
            this.addMethodAccessor(method, buf, this.isStatic(method));
        }
    }

    private void addInnerFields(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getDefaultFieldDeclaration((String)Object.class.getName(), (String)"__instance"));
        buf.append(JavaClassGeneratorHelper.getStaticPublicFieldDeclaration((String)IOpenClass.class.getName(), (String)"__class"));
        buf.append(JavaClassGeneratorHelper.getStaticPublicFieldDeclaration((String)CompiledOpenClass.class.getName(), (String)"__compiledClass"));
        buf.append("  private static Map<String, Object> __externalParams;\n");
        buf.append("  private static boolean __executionMode;\n");
        String initializationValue = String.format("\"%s\"", StringEscapeUtils.escapeJava((String)this.openlName));
        buf.append(JavaClassGeneratorHelper.getStaticPublicFieldInitialization((String)String.class.getName(), (String)"__openlName", (String)initializationValue));
        String initializationValueSrc = String.format("\"%s\"", StringEscapeUtils.escapeJava((String)(this.deplSrcFile == null ? this.srcFile : this.deplSrcFile)));
        buf.append(JavaClassGeneratorHelper.getStaticPublicFieldInitialization((String)String.class.getName(), (String)"__src", (String)initializationValueSrc));
        String initValue = this.srcModuleClass == null ? null : String.format("\"%s\"", StringEscapeUtils.escapeJava((String)this.srcModuleClass));
        buf.append(JavaClassGeneratorHelper.getStaticPublicFieldInitialization((String)String.class.getName(), (String)"__srcModuleClass", initValue));
        String initializationValueRulesFolder = String.format("\"%s\"", StringEscapeUtils.escapeJava((String)this.rulesFolder));
        buf.append(JavaClassGeneratorHelper.getStaticPublicFieldInitialization((String)String.class.getName(), (String)"__folder", (String)initializationValueRulesFolder));
        String initializationValueProject = String.format("\"%s\"", StringEscapeUtils.escapeJava((String)this.getRulesProject()));
        buf.append(JavaClassGeneratorHelper.getStaticPublicFieldInitialization((String)String.class.getName(), (String)"__project", (String)initializationValueProject));
        String initializationValueUserHome = String.format("\"%s\"", StringEscapeUtils.escapeJava((String)(this.deplUserHome == null ? this.userHome : this.deplUserHome)));
        buf.append(JavaClassGeneratorHelper.getStaticPublicFieldInitialization((String)String.class.getName(), (String)"__userHome", (String)initializationValueUserHome));
    }

    private void addImports(IOpenClass moduleOpenClass, StringBuffer buf) {
        int methodsNum = this.calcMethods(moduleOpenClass);
        if (methodsNum != 0) {
            for (String methodImport : this.methodImports) {
                this.addImport(buf, methodImport);
            }
        }
        for (String defaultImport : this.defaultImports) {
            this.addImport(buf, defaultImport);
        }
    }

    private void addConstructorWithParameter(StringBuffer buf) {
        buf.append("  public ").append(this.s_class).append("(){\n").append("    this(false);\n").append("  }\n\n");
        buf.append("  public ").append(this.s_class).append("(boolean ignoreErrors){\n").append("    this(ignoreErrors, false);\n").append("  }\n\n");
        buf.append("  public ").append(this.s_class).append("(boolean ignoreErrors, boolean executionMode){\n").append("    this(ignoreErrors, executionMode, null);\n").append("  }\n\n");
        buf.append("  public ").append(this.s_class).append("(Map<String, Object> params){\n").append("    this(false, false, params);\n").append("  }\n\n");
        buf.append("  public ").append(this.s_class).append("(boolean ignoreErrors, boolean executionMode, Map<String, Object> params){\n").append("    __externalParams = params;\n").append("    __executionMode = executionMode;\n").append("    __init();\n").append("    if (!ignoreErrors) __compiledClass.throwErrorExceptionsIfAny();\n").append("    __instance = __class.newInstance(__env.get());\n").append("  }\n\n");
        buf.append("");
    }

    private void addPackage(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getPackageText((String)this.s_package));
    }

    private int calcMethods(IOpenClass ioc) {
        int cnt = 0;
        for (IOpenMethod method : ioc.getMethods()) {
            if (!this.isMethodGenerated(method)) continue;
            ++cnt;
        }
        return cnt;
    }

    private void addMethodField(IOpenMethod method, StringBuffer buf) {
        buf.append("\n\n  static " + IOpenMethod.class.getName() + " " + this.getMethodFieldName(method) + ";\n");
    }

    private void addMethodFieldInitializer(IOpenMethod method) {
        this.initBuf.append("    " + this.getMethodFieldName(method) + " = __class.getMatchingMethod(\"" + method.getName() + "\", new IOpenClass[] {\n");
        IOpenClass[] params = method.getSignature().getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                this.initBuf.append(",\n");
            }
            this.initBuf.append("      OpenClassHelper.getOpenClass(__class, ").append(this.getClassName(params[i].getInstanceClass())).append(".class)");
        }
        this.initBuf.append("});\n");
    }

    private void addImport(StringBuffer buf, String str) {
        buf.append(JavaClassGeneratorHelper.getImportText((String)str));
    }

    private void addInitMethod(StringBuffer buf) {
        String initStart = "  static boolean __initialized = false;\n\n  static public void reset(){__initialized = false;}\n\npublic Object getInstance(){return __instance;}\n\npublic IOpenClass getOpenClass(){return __class;}\n\npublic org.openl.CompiledOpenClass getCompiledOpenClass(){return __compiledClass;}\n\npublic synchronized void  reload(){reset();__init();__instance = __class.newInstance(__env.get());}\n\n  static synchronized protected void __init()\n  {\n    if (__initialized)\n      return;\n\n    IUserContext ucxt = UserContext.makeOrLoadContext(Thread.currentThread().getContextClassLoader(), __userHome);\n    IOpenSourceCodeModule source = OpenClassJavaWrapper.getSourceCodeModule(__src, ucxt);\n    if (source != null) {\n         source.setParams(__externalParams);\n    }\n    OpenClassJavaWrapper wrapper = OpenClassJavaWrapper.createWrapper(__openlName, ucxt , source, __executionMode);\n    __compiledClass = wrapper.getCompiledClass();\n    __class = wrapper.getOpenClassWithErrors();\n   // __env.set(wrapper.getEnv());\n\n";
        buf.append(initStart).append(this.initBuf.toString()).append("\n    __initialized=true;\n  }\n");
    }

    private void addMethodAccessor(IOpenMethod method, StringBuffer buf, boolean isStatic) {
        this.addMethodSignature(method, buf, isStatic);
        this.addMethodBody(method, buf, isStatic);
    }

    private void addMethodBody(IOpenMethod method, StringBuffer buf, boolean isStatic) {
        buf.append("  {\n");
        IOpenClass[] ptypes = method.getSignature().getParameterTypes();
        buf.append("    Object[] __params = new Object[").append(ptypes.length).append("];");
        for (int i = 0; i < ptypes.length; ++i) {
            buf.append("\n    __params[").append(i).append("] = ").append(this.parameterToObject(method, i)).append(';');
        }
        buf.append("\n    try\n    {\n");
        buf.append("    Object __myInstance = ");
        if (isStatic) {
            buf.append("new " + this.s_class + "().");
        }
        buf.append("__instance;\n");
        buf.append(this.returnMethodVar(method, resName)).append(this.getMethodFieldName(method)).append(".invoke(__myInstance, __params, __env.get());");
        buf.append(this.returnMethodResult(method, resName));
        buf.append("  }\n  catch(Throwable t)\n  {\n    Log.error(\"Java Wrapper execution error:\", t);\n    throw RuntimeExceptionWrapper.wrap(t);\n  }\n");
        buf.append("\n  }\n");
    }

    private void addFieldField(IOpenField field, StringBuffer buf) {
        buf.append("\n\n  static " + IOpenField.class.getName() + " " + this.getFieldFieldName(field) + ";\n");
    }

    private void addFieldFieldInitializer(IOpenField field) {
        this.initBuf.append("    " + this.getFieldFieldName(field) + " = __class.getField(\"" + field.getName() + "\");\n");
    }

    private void addFieldModifier(IOpenField field, StringBuffer buf) {
        String varname = "__var";
        IOpenClass type = field.getType();
        String className = this.getClassName(type.getInstanceClass());
        buf.append("\n  public void set").append(this.fieldMethodPart(field)).append("(").append(className).append(' ').append(varname).append(")").append("\n  {\n").append("   ").append(this.getFieldFieldName(field)).append(".set(__instance, ").append(this.wrapIfPrimitive(varname, type.getInstanceClass())).append(", __env.get());\n").append("  }\n\n");
    }

    private void addMethodSignature(IOpenMethod method, StringBuffer buf, boolean isStatic) {
        buf.append("  public ");
        if (isStatic) {
            buf.append("static ");
        }
        buf.append(this.getMethodType(method)).append(' ');
        buf.append(this.getMethodName(method));
        buf.append('(');
        IOpenClass[] ptypes = method.getSignature().getParameterTypes();
        for (int i = 0; i < ptypes.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getOpenClassType(ptypes[i])).append(' ').append(this.getParamName(method.getSignature().getParameterName(i), i));
        }
        buf.append(')');
    }

    private String parameterToObject(IOpenMethod method, int i) {
        IOpenClass type = method.getSignature().getParameterTypes()[i];
        String name = this.getParamName(method.getSignature().getParameterName(i), i);
        Class instanceClass = type.getInstanceClass();
        if (instanceClass.isPrimitive()) {
            return this.wrapIfPrimitive(name, instanceClass);
        }
        return name;
    }

    private String returnMethodResult(IOpenMethod method, String resVarName) {
        IOpenClass type = method.getType();
        Class instanceClass = type.getInstanceClass();
        if (instanceClass == Void.TYPE) {
            return "";
        }
        return "\n   return " + this.castAndUnwrap(instanceClass, resVarName) + ";";
    }

    private String returnMethodVar(IOpenMethod method, String resVarName) {
        IOpenClass type = method.getType();
        Class instanceClass = type.getInstanceClass();
        if (instanceClass == Void.TYPE) {
            return "    ";
        }
        return "    Object " + resVarName + " = ";
    }

    private boolean isStatic(IOpenMethod method) {
        return false;
    }

    private String castAndUnwrap(Class<?> instanceClass, String resVarName) {
        if (instanceClass == Object.class) {
            return resVarName;
        }
        if (instanceClass.isPrimitive()) {
            return this.unwrapIfPrimitive(instanceClass, resVarName);
        }
        return "(" + this.getClassName(instanceClass) + ")" + resVarName;
    }

    private String fieldMethodPart(IOpenField field) {
        String name = field.getName();
        return StringUtils.capitalize((String)name);
    }

    private String getFieldFieldName(IOpenField field) {
        return field.getName() + "_Field";
    }

    private String unwrapIfPrimitive(Class<?> instanceClass, String name) {
        if (instanceClass == Integer.TYPE) {
            return "((Integer)" + name + ").intValue()";
        }
        if (instanceClass == Double.TYPE) {
            return "((Double)" + name + ").doubleValue()";
        }
        if (instanceClass == Boolean.TYPE) {
            return "((Boolean)" + name + ").booleanValue()";
        }
        if (instanceClass == Character.TYPE) {
            return "((Character)" + name + ").charValue()";
        }
        if (instanceClass == Long.TYPE) {
            return "((Long)" + name + ").longValue()";
        }
        if (instanceClass == Short.TYPE) {
            return "((Short)" + name + ").shortValue()";
        }
        if (instanceClass == Float.TYPE) {
            return "((Float)" + name + ").floatValue()";
        }
        return name;
    }

    private String wrapIfPrimitive(String name, Class<?> instanceClass) {
        if (instanceClass == Integer.TYPE) {
            return "new Integer(" + name + ")";
        }
        if (instanceClass == Double.TYPE) {
            return "new Double(" + name + ")";
        }
        if (instanceClass == Boolean.TYPE) {
            return "new Boolean(" + name + ")";
        }
        if (instanceClass == Character.TYPE) {
            return "new Character(" + name + ")";
        }
        if (instanceClass == Long.TYPE) {
            return "new Long(" + name + ")";
        }
        if (instanceClass == Short.TYPE) {
            return "new Short(" + name + ")";
        }
        if (instanceClass == Float.TYPE) {
            return "new Float(" + name + ")";
        }
        return name;
    }

    private boolean isFieldGenerated(IOpenField field) {
        if (this.fields != null && !ArrayTool.contains((Object)this.fields, (Object)field.getName())) {
            return false;
        }
        IOpenClass type = field.getType();
        return !this.ignoreNonJavaTypes || type instanceof JavaOpenClass;
    }

    private boolean isMethodGenerated(IOpenMethod method) {
        if (this.moduleOpenClass.getName().equals(method.getName())) {
            return false;
        }
        if ("getOpenClass".equals(method.getName())) {
            return false;
        }
        if (this.methods != null && !ArrayTool.contains((Object)this.methods, (Object)method.getName())) {
            return false;
        }
        IOpenClass type = method.getType();
        if (this.ignoreNonJavaTypes && !(type instanceof JavaOpenClass)) {
            return false;
        }
        IOpenClass[] params = method.getSignature().getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            type = params[i];
            if (!this.ignoreNonJavaTypes || type instanceof JavaOpenClass) continue;
            return false;
        }
        return true;
    }

    private String getMethodFieldName(IOpenMethod method) {
        String methodName = this.getMethodName(method);
        ASelector.StringValueSelector nameSel = new ASelector.StringValueSelector(methodName, (AStringConvertor)INamedThing.NAME_CONVERTOR);
        List list = AOpenIterator.select(this.moduleOpenClass.getMethods().iterator(), (ISelector)nameSel).asList();
        if (list.size() == 1) {
            return methodName + "_Method";
        }
        int index = list.indexOf(method);
        return methodName + index + "_Method";
    }

    private String getMethodName(IOpenMethod method) {
        return method.getName();
    }

    private String getMethodType(IOpenMethod method) {
        return this.getOpenClassType(method.getType());
    }

    private String getOpenClassType(IOpenClass type) {
        return this.getClassName(type.getInstanceClass());
    }

    private String getParamName(String parameterName, int i) {
        return parameterName == null ? "arg" + i : parameterName;
    }

    private String getClassName(Class<?> instanceClass) {
        StringBuffer buf = new StringBuffer(30);
        while (instanceClass.isArray()) {
            buf.append("[]");
            instanceClass = instanceClass.getComponentType();
        }
        buf.insert(0, this.getScalarClassName(instanceClass));
        return buf.toString();
    }

    private String getRulesProject() {
        try {
            String file = new File(".").getCanonicalFile().toString();
            String[] tokens = StringTool.tokenize((String)file, (String)"/\\");
            return tokens[tokens.length - 1];
        }
        catch (IOException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    private String getScalarClassName(Class<?> instanceClass) {
        return instanceClass.getName();
    }
}

