/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.event;

import java.util.Map;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.table.IGridTable;
import org.openl.rules.tableeditor.model.TableEditorModel;
import org.openl.rules.tableeditor.model.ui.TableModel;
import org.openl.rules.tableeditor.renderkit.HTMLRenderer;

public class BaseTableEditorController {
    protected IGridTable getGridTable(String editorId) {
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            return editorModel.getGridTable();
        }
        return null;
    }

    protected TableEditorModel getEditorModel(String editorId) {
        Map editorModelMap = (Map)FacesUtils.getSessionParam((String)"_tableEditorModel");
        if (editorModelMap != null) {
            return (TableEditorModel)editorModelMap.get(editorId);
        }
        return null;
    }

    protected TableModel initializeTableModel(String editorId) {
        IGridTable table = this.getGridTable(editorId);
        return TableModel.initializeTableModel(table);
    }

    protected String render(String editorId) {
        TableModel tableModel = this.initializeTableModel(editorId);
        TableEditorModel editorModel = this.getEditorModel(editorId);
        HTMLRenderer.TableRenderer tableRenderer = new HTMLRenderer.TableRenderer(tableModel);
        tableRenderer.setCellIdPrefix(editorId + "_cell-");
        return tableRenderer.render(editorModel.isShowFormulas());
    }
}

