/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.event;

import com.sdicons.json.mapper.JSONMapper;
import com.sdicons.json.mapper.MapperException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.formula.FormulaParseException;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.ui.CellStyle;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.tableeditor.event.BaseTableEditorController;
import org.openl.rules.tableeditor.event.ITableEditorController;
import org.openl.rules.tableeditor.model.CellEditorSelector;
import org.openl.rules.tableeditor.model.ICellEditor;
import org.openl.rules.tableeditor.model.TableEditorModel;
import org.openl.rules.tableeditor.renderkit.HTMLRenderer;
import org.openl.rules.tableeditor.renderkit.TableEditor;

public class TableEditorController
extends BaseTableEditorController
implements ITableEditorController {
    private static final Log LOG = LogFactory.getLog(TableEditorController.class);
    private static final String ERROR_SET_NEW_VALUE = "Error on setting new value to the cell. ";
    private static final String ERROR_SAVE_TABLE = "Failed to save table.";
    private static final String ERROR_OPENED_EXCEL = "Failed to save table. Please close project Excel file and try again.";

    public String edit() {
        String editorId = this.getEditorId();
        String cellToEdit = this.getRequestParam("cell");
        String errorCell = this.getRequestParam("errorCell");
        TableEditorModel editorModel = this.getEditorModel(editorId);
        TableEditor editor = editorModel.getTableEditor();
        editor.setMode("edit");
        return new HTMLRenderer().render(editor, true, cellToEdit, null, errorCell);
    }

    public String insertRowBefore() {
        int row = this.getRow();
        int col = this.getCol();
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            TableModificationResponse tmResponse = new TableModificationResponse(null, editorModel);
            try {
                if (row >= 0) {
                    editorModel.insertRows(1, row, col);
                    tmResponse.setResponse(this.render(editorId));
                } else {
                    tmResponse.setStatus("Can not insert row");
                }
            }
            catch (Exception e) {
                tmResponse.setStatus("Internal server error");
                LOG.error((Object)"Internal server error", (Throwable)e);
            }
            return TableEditorController.pojo2json(tmResponse);
        }
        return null;
    }

    public String insertColumnBefore() {
        int col = this.getCol();
        int row = this.getRow();
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            TableModificationResponse tmResponse = new TableModificationResponse(null, editorModel);
            try {
                if (col >= 0) {
                    editorModel.insertColumns(1, col, row);
                    tmResponse.setResponse(this.render(editorId));
                } else {
                    tmResponse.setStatus("Can not insert column");
                }
            }
            catch (Exception e) {
                tmResponse.setStatus("Internal server error");
                LOG.error((Object)"Internal server error", (Throwable)e);
            }
            return TableEditorController.pojo2json(tmResponse);
        }
        return null;
    }

    public String getCellType() {
        TableEditorModel editorModel = this.getEditorModel(this.getEditorId());
        if (editorModel != null) {
            ICell cell = editorModel.getOriginalGridTable().getCell(this.getCol(), this.getRow());
            ICellEditor editor = new CellEditorSelector().selectEditor(cell);
            EditorTypeResponse typeResponse = editor.getEditorTypeAndMetadata();
            return TableEditorController.pojo2json(typeResponse);
        }
        return "";
    }

    private int getCol() {
        TableEditorModel editorModel = this.getEditorModel(this.getEditorId());
        int numberOfNonShownColumns = editorModel.getNumberOfNonShownCols();
        return this.getRequestIntParam("col") - 1 + numberOfNonShownColumns;
    }

    private String getEditorId() {
        return this.getRequestParam("editorId");
    }

    private int getRequestIntParam(String name) {
        int param = -1;
        try {
            String requestParam = this.getRequestParam(name);
            if (requestParam != null) {
                param = Integer.parseInt(requestParam);
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Error when trying to get param", (Throwable)e);
        }
        return param;
    }

    private String getRequestParam(String name) {
        return FacesUtils.getRequestParameter((String)name);
    }

    private int getRow() {
        TableEditorModel editorModel = this.getEditorModel(this.getEditorId());
        int numberOfNonShownRows = editorModel.getNumberOfNonShownRows();
        return this.getRequestIntParam("row") - 1 + numberOfNonShownRows;
    }

    public String load() {
        String editorId = this.getEditorId();
        String response = this.render(editorId);
        IGridTable gridTable = this.getGridTable(editorId);
        response = TableEditorController.pojo2json(new LoadResponse(response, gridTable.getGrid().getCell(gridTable.getGridColumn(0, 0), gridTable.getGridRow(0, 0)).getUri(), this.getEditorModel(editorId)));
        return response;
    }

    public String removeRow() {
        int row = this.getRow();
        int col = this.getCol();
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null && row >= 0 && col >= 0) {
            editorModel.removeRows(1, row, col);
            return TableEditorController.pojo2json(new TableModificationResponse(this.render(editorId), editorModel));
        }
        return null;
    }

    public String removeColumn() {
        int col = this.getCol();
        int row = this.getRow();
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null && col >= 0 && row >= 0) {
            editorModel.removeColumns(1, col, row);
            return TableEditorController.pojo2json(new TableModificationResponse(this.render(editorId), editorModel));
        }
        return null;
    }

    public String setIndent() {
        int row = this.getRow();
        int col = this.getCol();
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            int indent = this.getRequestIntParam("indent");
            ICellStyle style = editorModel.getOriginalGridTable().getCell(col, row).getStyle();
            int currentIndent = style.getIdent();
            int resultIndent = currentIndent + indent;
            CellStyle newStyle = new CellStyle(style);
            newStyle.setIdent(resultIndent >= 0 ? resultIndent : 0);
            editorModel.setStyle(row, col, (ICellStyle)newStyle);
            return TableEditorController.pojo2json(new TableModificationResponse(null, editorModel));
        }
        return null;
    }

    public String setCellValue() {
        String value = this.getRequestParam("value");
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            String message = null;
            try {
                editorModel.setCellValue(this.getRow(), this.getCol(), value);
            }
            catch (FormulaParseException ex) {
                LOG.warn((Object)"ERROR_SET_NEW_VALUE", (Throwable)ex);
                message = ERROR_SET_NEW_VALUE + ex.getMessage();
            }
            TableModificationResponse tmResponse = new TableModificationResponse(null, editorModel);
            if (message != null) {
                tmResponse.setStatus(message);
            } else if (value.startsWith("=")) {
                tmResponse.setResponse(this.render(editorId));
            }
            return TableEditorController.pojo2json(tmResponse);
        }
        return null;
    }

    public String setProperty() throws Exception {
        String name = this.getRequestParam("propName");
        String value = this.getRequestParam("propValue");
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            ITableProperties props;
            InheritanceLevel inheritanceLevel;
            editorModel.setProperty(name, value);
            PropertyModificationResponse response = new PropertyModificationResponse(editorModel);
            if (!editorModel.isBusinessView()) {
                response.setResponse(this.render(editorId));
            }
            if (StringUtils.isBlank((String)value) && (InheritanceLevel.MODULE.equals((Object)(inheritanceLevel = (props = editorModel.getTable().getProperties()).getPropertyLevelDefinedOn(name))) || InheritanceLevel.CATEGORY.equals((Object)inheritanceLevel))) {
                String inheritedValue = props.getPropertyValueAsString(name);
                response.setInheritedValue(inheritedValue);
            }
            return TableEditorController.pojo2json(response);
        }
        return null;
    }

    public String setAlign() {
        int row = this.getRow();
        int col = this.getCol();
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            ICellStyle style;
            String align = this.getRequestParam("align");
            int halign = -1;
            if ("left".equalsIgnoreCase(align)) {
                halign = 1;
            } else if ("center".equalsIgnoreCase(align)) {
                halign = 2;
            } else if ("right".equalsIgnoreCase(align)) {
                halign = 3;
            } else if ("justify".equalsIgnoreCase(align)) {
                halign = 5;
            }
            if (halign != -1 && (style = editorModel.getOriginalGridTable().getCell(col, row).getStyle()).getHorizontalAlignment() != halign) {
                CellStyle newStyle = new CellStyle(style);
                newStyle.setHorizontalAlignment(halign);
                editorModel.setStyle(row, col, (ICellStyle)newStyle);
            }
            return TableEditorController.pojo2json(new TableModificationResponse(null, editorModel));
        }
        return null;
    }

    public String undo() {
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            TableModificationResponse tmResponse = new TableModificationResponse(null, editorModel);
            if (editorModel.hasUndo()) {
                editorModel.undo();
                tmResponse.setResponse(this.render(editorId));
            } else {
                tmResponse.setStatus("No actions to undo");
            }
            return TableEditorController.pojo2json(tmResponse);
        }
        return null;
    }

    public String redo() {
        String editorId = this.getEditorId();
        TableEditorModel editorModel = this.getEditorModel(editorId);
        if (editorModel != null) {
            TableModificationResponse tmResponse = new TableModificationResponse(null, editorModel);
            if (editorModel.hasRedo()) {
                editorModel.redo();
                tmResponse.setResponse(this.render(editorId));
            } else {
                tmResponse.setStatus("No actions to redo");
            }
            return TableEditorController.pojo2json(tmResponse);
        }
        return null;
    }

    public String saveTable() {
        TableEditorModel editorModel = this.getEditorModel(this.getEditorId());
        if (editorModel != null) {
            TableModificationResponse tmResponse = new TableModificationResponse(null, editorModel);
            try {
                if (this.beforeSave()) {
                    String newUri = editorModel.save();
                    this.afterSave(newUri);
                    tmResponse.setResponse(newUri);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)ERROR_SAVE_TABLE, (Throwable)e);
                tmResponse.setStatus(ERROR_OPENED_EXCEL);
            }
            catch (Exception e) {
                LOG.error((Object)ERROR_SAVE_TABLE, (Throwable)e);
                tmResponse.setStatus(ERROR_SAVE_TABLE);
            }
            return TableEditorController.pojo2json(tmResponse);
        }
        return null;
    }

    private boolean beforeSave() {
        TableEditorModel editorModel = this.getEditorModel(this.getEditorId());
        String beforeSaveAction = editorModel.getBeforeSaveAction();
        if (beforeSaveAction != null) {
            boolean result = (Boolean)FacesUtils.invokeMethodExpression((String)beforeSaveAction);
            return result;
        }
        return true;
    }

    private void afterSave(String newUri) {
        TableEditorModel editorModel = this.getEditorModel(this.getEditorId());
        String afterSaveAction = editorModel.getAfterSaveAction();
        if (afterSaveAction != null) {
            Class[] classArray;
            Object[] objectArray;
            if (StringUtils.isNotBlank((String)newUri)) {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = newUri;
            } else {
                objectArray = null;
            }
            if (StringUtils.isNotBlank((String)newUri)) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = String.class;
            } else {
                classArray = null;
            }
            FacesUtils.invokeMethodExpression((String)afterSaveAction, (Object[])objectArray, classArray);
        }
    }

    private static String pojo2json(Object pojo) {
        try {
            return "(" + JSONMapper.toJSON((Object)pojo).render(true) + ")";
        }
        catch (MapperException e) {
            return null;
        }
    }

    public static class PropertyModificationResponse
    extends TableModificationResponse {
        private String inheritedValue;

        public PropertyModificationResponse(TableEditorModel model) {
            super(null, null, model);
        }

        public PropertyModificationResponse(String response, String status, TableEditorModel model, String inheritedValue) {
            super(response, status, model);
            this.inheritedValue = inheritedValue;
        }

        public String getInheritedValue() {
            return this.inheritedValue;
        }

        public void setInheritedValue(String inheritedValue) {
            this.inheritedValue = inheritedValue;
        }
    }

    public static class TableModificationResponse {
        private String response;
        private String status;
        private TableEditorModel model;

        public TableModificationResponse(String response, String status, TableEditorModel model) {
            this.response = response;
            this.status = status;
            this.model = model;
        }

        public TableModificationResponse(String response, TableEditorModel model) {
            this.response = response;
            this.model = model;
        }

        public String getResponse() {
            return this.response;
        }

        public String getStatus() {
            return this.status;
        }

        public boolean isHasRedo() {
            return this.model != null && this.model.hasRedo();
        }

        public boolean isHasUndo() {
            return this.model != null && this.model.hasUndo();
        }

        public void setHasRedo(boolean hasRedo) {
        }

        public void setHasUndo(boolean hasUndo) {
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    public static class LoadResponse {
        private String tableHTML;
        private String topLeftCell;
        private TableEditorModel model;

        public LoadResponse(String tableHTML, String topLeftCell, TableEditorModel model) {
            this.tableHTML = tableHTML;
            this.topLeftCell = topLeftCell;
            this.model = model;
        }

        public String getTableHTML() {
            return this.tableHTML;
        }

        public String getTopLeftCell() {
            return this.topLeftCell;
        }

        public boolean isHasRedo() {
            return this.model != null && this.model.hasRedo();
        }

        public boolean isHasUndo() {
            return this.model != null && this.model.hasUndo();
        }

        public void setHasRedo(boolean hasRedo) {
        }

        public void setHasUndo(boolean hasUndo) {
        }

        public void setTableHTML(String tableHTML) {
            this.tableHTML = tableHTML;
        }

        public void setTopLeftCell(String topLeftCell) {
            this.topLeftCell = topLeftCell;
        }
    }

    public static class EditorTypeResponse {
        private String editor;
        private Object params;

        public EditorTypeResponse(String editor) {
            this.editor = editor;
        }

        public String getEditor() {
            return this.editor;
        }

        public Object getParams() {
            return this.params;
        }

        public void setEditor(String editor) {
            this.editor = editor;
        }

        public void setParams(Object params) {
            this.params = params;
        }
    }
}

