/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.event;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.commons.web.jsf.FacesUtils;

public class TableEditorDispatcher
implements PhaseListener {
    private static final long serialVersionUID = 8617343432886373802L;
    private static final Log LOG = LogFactory.getLog(TableEditorDispatcher.class);
    private static final String AJAX_MATCH = "ajax/";

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        ExternalContext extContext = event.getFacesContext().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)extContext.getResponse();
        String uri = request.getRequestURI();
        if (uri.indexOf("/tableEditor/") > -1) {
            String path = uri.substring(uri.indexOf("/tableEditor/") + "/tableEditor/".length());
            if (path.startsWith(AJAX_MATCH)) {
                this.handleAjaxRequest(context, response, path);
            } else {
                this.handleResourceRequest(context, response, path);
            }
        }
    }

    private void handleAjaxRequest(FacesContext context, HttpServletResponse response, String path) {
        try {
            String methodExpressionString = this.makeMehtodExpressionString(path.replaceFirst(AJAX_MATCH, ""));
            String res = (String)FacesUtils.invokeMethodExpression((String)methodExpressionString);
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            PrintWriter writer = response.getWriter();
            if (res != null) {
                writer.write(res);
            }
            writer.close();
            context.responseComplete();
        }
        catch (IOException e) {
            LOG.error((Object)"Could not handle Ajax request", (Throwable)e);
        }
    }

    private void handleResourceRequest(FacesContext context, HttpServletResponse response, String path) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream is = cl.getResourceAsStream(path);
            if (is == null) {
                return;
            }
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[2048];
            BufferedInputStream bis = new BufferedInputStream(is);
            int read = 0;
            read = bis.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = bis.read(buffer);
            }
            bis.close();
            out.flush();
            out.close();
            context.responseComplete();
        }
        catch (IOException e) {
            LOG.error((Object)"Could not handle Resource request", (Throwable)e);
        }
    }

    private String makeMehtodExpressionString(String request) {
        int pos = request.indexOf(63);
        if (pos >= 0) {
            request = request.substring(0, pos);
        }
        return "#{" + "_tableEditorController" + "." + request + '}';
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

