/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.lang.ClassUtils;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.tableeditor.model.CellEditorFactory;
import org.openl.rules.tableeditor.model.ICellEditor;
import org.openl.rules.tableeditor.model.ICellEditorFactory;
import org.openl.types.IOpenClass;
import org.openl.util.EnumUtils;
import org.openl.util.NumberUtils;

public class CellEditorSelector {
    private ICellEditorFactory factory = new CellEditorFactory();

    public ICellEditor selectEditor(ICell cell) {
        if (cell != null && cell.getFormula() != null) {
            return this.factory.makeFormulaEditor();
        }
        CellMetaInfo cellMetaInfo = cell.getMetaInfo();
        ICellEditor editor = this.selectEditor(cellMetaInfo);
        return editor == null ? this.defaultEditor(cell) : editor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ICellEditor selectEditor(CellMetaInfo meta) {
        ICellEditor result = null;
        IOpenClass dataType = meta == null ? null : meta.getDataType();
        if (dataType == null) return result;
        IDomain domain = dataType.getDomain();
        Class instanceClass = dataType.getInstanceClass();
        if (ClassUtils.isAssignable((Class)instanceClass, Double.TYPE, (boolean)true) || instanceClass == BigInteger.class || instanceClass == BigDecimal.class) {
            if (domain != null) return result;
            if (meta.isMultiValue()) return this.factory.makeArrayEditor(",", "numeric");
            Number minValue = NumberUtils.getMinValue((Class)instanceClass);
            Number maxValue = NumberUtils.getMaxValue((Class)instanceClass);
            return this.factory.makeNumericEditor(minValue, maxValue);
        }
        if (instanceClass == String.class) {
            if (!(domain instanceof EnumDomain)) return result;
            EnumDomain enumDomain = (EnumDomain)domain;
            if (!meta.isMultiValue()) return this.factory.makeComboboxEditor((String[])enumDomain.getEnum().getAllObjects());
            return this.factory.makeMultiSelectEditor((String[])enumDomain.getEnum().getAllObjects());
        }
        if (instanceClass == Date.class) {
            return this.factory.makeDateEditor();
        }
        if (instanceClass == Boolean.TYPE) return this.factory.makeBooleanEditor();
        if (instanceClass == Boolean.class) {
            return this.factory.makeBooleanEditor();
        }
        if (!instanceClass.isEnum()) return result;
        String[] values = EnumUtils.getNames((Class)instanceClass);
        String[] displayValues = EnumUtils.getValues((Class)instanceClass);
        if (!meta.isMultiValue()) return this.factory.makeComboboxEditor(values, displayValues);
        return this.factory.makeMultiSelectEditor(values, displayValues);
    }

    private ICellEditor defaultEditor(ICell cell) {
        String cellValue = cell.getStringValue();
        return cellValue != null && cellValue.indexOf(10) >= 0 ? this.factory.makeMultilineEditor() : this.factory.makeTextEditor();
    }
}

