/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.model;

import org.openl.rules.tableeditor.event.TableEditorController;
import org.openl.rules.tableeditor.model.ComboBoxCellEditor;
import org.openl.util.StringTool;

public class MultiSelectCellEditor
extends ComboBoxCellEditor {
    public MultiSelectCellEditor(String[] choices, String[] displayValues) {
        super(displayValues);
        String[] insertedEscChoices = new String[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            insertedEscChoices[i] = StringTool.insertStringToString((String)choices[i], (String)",", (String)"\\");
        }
        super.setChoices(insertedEscChoices);
    }

    public TableEditorController.EditorTypeResponse getEditorTypeAndMetadata() {
        TableEditorController.EditorTypeResponse typeResponse = new TableEditorController.EditorTypeResponse("multiselect");
        typeResponse.setParams(new MultiChoiceParam(this.getChoices(), this.getDisplayValues(), ",", "\\"));
        return typeResponse;
    }

    public static class MultiChoiceParam
    extends ComboBoxCellEditor.ComboBoxParam {
        private String separator;
        private String separatorEscaper;

        public MultiChoiceParam(String[] choices, String[] displayValues, String separator, String separatorEscaper) {
            super(choices, displayValues);
            this.separator = separator;
            this.setSeparatorEscaper(separatorEscaper);
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public void setSeparatorEscaper(String separatorEscaper) {
            this.separatorEscaper = separatorEscaper;
        }

        public String getSeparatorEscaper() {
            return this.separatorEscaper;
        }
    }
}

