/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.model;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.table.AGridTableDecorator;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.UndoableActions;
import org.openl.rules.table.actions.UndoableCompositeAction;
import org.openl.rules.table.actions.UndoableEditTableAction;
import org.openl.rules.table.actions.UndoableInsertColumnsAction;
import org.openl.rules.table.actions.UndoableInsertRowsAction;
import org.openl.rules.table.actions.UndoableRemoveColumnsAction;
import org.openl.rules.table.actions.UndoableRemoveRowsAction;
import org.openl.rules.table.ui.FilteredGrid;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.ui.filters.IGridFilter;
import org.openl.rules.table.ui.filters.SimpleFormatFilter;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.tableeditor.renderkit.TableEditor;
import org.openl.util.formatters.IFormatter;

public class TableEditorModel {
    public static final int NUMBER_PROPERTIES_COLUMNS = 3;
    private IOpenLTable table;
    private IGridTable gridTable;
    private String view;
    private boolean showFormulas = false;
    private boolean collapseProps = false;
    private String beforeSaveAction;
    private String afterSaveAction;
    private String saveFailureAction;
    private UndoableActions actions = new UndoableActions();
    private FilteredGrid filteredGrid;
    private TableEditor tableEditor;

    public TableEditorModel(TableEditor editor) {
        this(editor.getTable(), editor.getView(), editor.isShowFormulas());
        this.setTableEditor(editor);
    }

    public TableEditorModel(IOpenLTable table, String view, boolean showFormulas) {
        this.table = table;
        this.gridTable = table.getGridTable(view);
        this.view = this.gridTable == table.getGridTable() ? "view.developer" : view;
        this.showFormulas = showFormulas;
        this.makeFilteredGrid(this.gridTable);
    }

    public boolean isBusinessView() {
        return this.view != null && this.view.equalsIgnoreCase("view.business");
    }

    public synchronized void cancel() {
        while (this.actions.hasUndo()) {
            this.undo();
        }
    }

    private IFormatter getFormatter(int col, int row) {
        IGridFilter filter;
        IFormatter formatter = null;
        IGridRegion originalRegion = this.getOriginalTableRegion();
        FormattedCell fc = this.filteredGrid.getFormattedCell(originalRegion.getLeft() + col, originalRegion.getTop() + row);
        if (fc != null && (filter = fc.getFilter()) != null) {
            formatter = filter.getFormatter();
        }
        return formatter;
    }

    public IOpenLTable getTable() {
        return this.table;
    }

    public IGridTable getGridTable() {
        return this.gridTable;
    }

    public synchronized boolean hasRedo() {
        return this.actions.hasRedo();
    }

    public synchronized boolean hasUndo() {
        return this.actions.hasUndo();
    }

    public IGridTable getOriginalGridTable() {
        IGridTable resultTable = this.gridTable;
        while (resultTable instanceof AGridTableDecorator) {
            resultTable = ((AGridTableDecorator)resultTable).getOriginalGridTable();
        }
        return resultTable;
    }

    public IGridRegion getOriginalTableRegion() {
        return this.getOriginalGridTable().getRegion();
    }

    public synchronized void insertColumns(int nCols, int beforeCol, int row) throws Exception {
        UndoableInsertColumnsAction insertColumnsAction = new UndoableInsertColumnsAction(nCols, beforeCol, row);
        insertColumnsAction.doAction(this.gridTable);
        this.actions.addNewAction((IUndoableAction)insertColumnsAction);
    }

    public synchronized void insertRows(int nRows, int beforeRow, int col) throws Exception {
        UndoableInsertRowsAction insertRowsAction = new UndoableInsertRowsAction(nRows, beforeRow, col);
        insertRowsAction.doAction(this.gridTable);
        this.actions.addNewAction((IUndoableAction)insertRowsAction);
    }

    private void makeFilteredGrid(IGridTable gt) {
        IGrid g = gt.getGrid();
        if (g instanceof FilteredGrid) {
            this.filteredGrid = (FilteredGrid)g;
            return;
        }
        this.filteredGrid = new FilteredGrid(gt.getGrid(), new IGridFilter[]{new SimpleFormatFilter()});
    }

    public synchronized void redo() {
        IUndoableAction ua = this.actions.getRedoAction();
        ((IUndoableGridTableAction)ua).doAction(this.gridTable);
    }

    public synchronized void removeRows(int nRows, int startRow, int col) {
        UndoableRemoveRowsAction removeRowsAction = new UndoableRemoveRowsAction(nRows, startRow, col);
        removeRowsAction.doAction(this.gridTable);
        this.actions.addNewAction((IUndoableAction)removeRowsAction);
    }

    public synchronized void removeColumns(int nCols, int startCol, int row) {
        UndoableRemoveColumnsAction removeColumnsAction = new UndoableRemoveColumnsAction(nCols, startCol, row);
        removeColumnsAction.doAction(this.gridTable);
        this.actions.addNewAction((IUndoableAction)removeColumnsAction);
    }

    public synchronized String save() throws IOException {
        XlsSheetGridModel xlsgrid = (XlsSheetGridModel)this.gridTable.getGrid();
        xlsgrid.getSheetSource().getWorkbookSource().save();
        this.actions = new UndoableActions();
        return this.getOriginalGridTable().getUri();
    }

    public XlsSheetSourceCodeModule getSheetSource() {
        XlsSheetGridModel xlsgrid = (XlsSheetGridModel)this.gridTable.getGrid();
        return xlsgrid.getSheetSource();
    }

    public synchronized void saveAs(String fname) throws IOException {
        this.getSheetSource().getWorkbookSource().saveAs(fname);
    }

    public synchronized void setCellValue(int row, int col, String value) {
        IUndoableGridTableAction action = IWritableGrid.Tool.setStringValue((int)col, (int)row, (IGridRegion)this.getOriginalTableRegion(), (String)value, (IFormatter)this.getFormatter(col, row));
        action.doAction(this.gridTable);
        this.actions.addNewAction((IUndoableAction)action);
    }

    public synchronized void setProperty(String name, String value) throws Exception {
        ArrayList<Object> createdActions = new ArrayList<Object>();
        int nRowsToInsert = 0;
        int nColsToInsert = 0;
        IGridTable fullTable = this.getOriginalGridTable();
        IGridRegion fullTableRegion = fullTable.getRegion();
        CellKey propertyCoordinates = IWritableGrid.Tool.getPropertyCoordinates((IGridRegion)fullTableRegion, (IGridTable)this.gridTable, (String)name);
        boolean propExists = propertyCoordinates != null;
        boolean propIsBlank = StringUtils.isBlank((String)value);
        if (!propIsBlank && !propExists) {
            int tableWidth = fullTable.getWidth();
            if (tableWidth < 3) {
                nColsToInsert = 3 - tableWidth;
            }
            if ((nRowsToInsert = 1) > 0 && !UndoableInsertRowsAction.canInsertRows((IGridTable)this.gridTable, (int)nRowsToInsert) || !UndoableInsertColumnsAction.canInsertColumns((IGridTable)this.gridTable, (int)nColsToInsert)) {
                createdActions.add(UndoableEditTableAction.moveTable((IGridTable)fullTable));
            }
            GridRegionAction allTable = new GridRegionAction(fullTableRegion, false, true, GridRegionAction.ActionType.EXPAND, nRowsToInsert);
            allTable.doAction(this.gridTable);
            createdActions.add(allTable);
            if (this.isBusinessView()) {
                GridRegionAction displayedTable = new GridRegionAction(this.gridTable.getRegion(), false, true, GridRegionAction.ActionType.MOVE, nRowsToInsert);
                displayedTable.doAction(this.gridTable);
                createdActions.add(displayedTable);
            }
        } else if (propIsBlank && propExists) {
            this.removeRows(1, propertyCoordinates.getRow(), propertyCoordinates.getColumn());
            return;
        }
        IUndoableGridTableAction action = IWritableGrid.Tool.insertProp((IGridRegion)fullTableRegion, (IGridTable)this.gridTable, (String)name, (String)value);
        if (action != null) {
            action.doAction(this.gridTable);
            createdActions.add(action);
        }
        if (!createdActions.isEmpty()) {
            this.actions.addNewAction((IUndoableAction)new UndoableCompositeAction(createdActions));
        }
    }

    public synchronized void setStyle(int row, int col, ICellStyle style) {
        IUndoableGridTableAction ua = IWritableGrid.Tool.setStyle((int)col, (int)row, (IGridRegion)this.getOriginalTableRegion(), (ICellStyle)style);
        ua.doAction(this.gridTable);
        this.actions.addNewAction((IUndoableAction)ua);
    }

    public int getNumberOfNonShownRows() {
        return IGridRegion.Tool.height((IGridRegion)this.getOriginalTableRegion()) - IGridRegion.Tool.height((IGridRegion)this.gridTable.getRegion());
    }

    public int getNumberOfNonShownCols() {
        return IGridRegion.Tool.width((IGridRegion)this.getOriginalTableRegion()) - IGridRegion.Tool.width((IGridRegion)this.gridTable.getRegion());
    }

    public synchronized void undo() {
        IUndoableAction ua = this.actions.getUndoAction();
        ((IUndoableGridTableAction)ua).undoAction(this.gridTable);
    }

    public boolean isShowFormulas() {
        return this.showFormulas;
    }

    public void setShowFormulas(boolean showFormulas) {
        this.showFormulas = showFormulas;
    }

    public boolean isCollapseProps() {
        return this.collapseProps;
    }

    public void setCollapseProps(boolean collapseProps) {
        this.collapseProps = collapseProps;
    }

    public void setBeforeSaveAction(String beforeSaveAction) {
        this.beforeSaveAction = beforeSaveAction;
    }

    public String getBeforeSaveAction() {
        return this.beforeSaveAction;
    }

    public void setAfterSaveAction(String afterSaveAction) {
        this.afterSaveAction = afterSaveAction;
    }

    public String getAfterSaveAction() {
        return this.afterSaveAction;
    }

    public String getSaveFailureAction() {
        return this.saveFailureAction;
    }

    public void setSaveFailureAction(String saveFailureAction) {
        this.saveFailureAction = saveFailureAction;
    }

    public void setTableEditor(TableEditor tableEditor) {
        this.tableEditor = tableEditor;
    }

    public TableEditor getTableEditor() {
        return this.tableEditor;
    }
}

