/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.model.ui;

import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.tableeditor.model.ui.BorderStyle;
import org.openl.rules.tableeditor.model.ui.ICellModel;
import org.openl.rules.tableeditor.model.ui.TableModel;
import org.openl.rules.tableeditor.model.ui.util.HTMLHelper;

public class CellModel
implements ICellModel {
    public static final short[] WHITE = new short[]{255, 255, 255};
    private int row;
    private int column;
    private int colspan = 1;
    private int rowspan = 1;
    private int ident = 0;
    private String halign;
    private String valign;
    private short[] rgbBackground;
    private BorderStyle[] borderStyle;
    private int cellPadding = 1;
    private boolean hasFormula;
    private String formula;
    private String content = "&nbsp;";
    private ICellFont font;
    private int width;

    static int calcMaxLineLength(String content) {
        int max = 0;
        int from = 0;
        int idx1;
        while ((idx1 = content.indexOf(10, from)) > 0) {
            max = Math.max(max, idx1 - from);
            from = idx1 + 1;
        }
        return max;
    }

    public CellModel(int row, int column) {
        this.row = row;
        this.column = column;
        this.hasFormula = false;
    }

    public void atttributesToHtml(StringBuilder buf, TableModel table, boolean selectErrorCell) {
        if (this.colspan != 1) {
            buf.append(" colspan=\"").append(this.colspan).append("\"");
        }
        if (this.rowspan != 1) {
            buf.append(" rowspan=\"").append(this.rowspan).append("\"");
        }
        String style = this.getHtmlStyle(table, selectErrorCell);
        buf.append(" style=\"" + style + "\"");
    }

    public void atttributesToHtml(StringBuilder buf, TableModel table) {
        this.atttributesToHtml(buf, table, false);
    }

    private void borderToHtml(StringBuilder buf, TableModel table) {
        int i;
        if (this.borderStyle == null) {
            return;
        }
        buf.append(" border-style: ");
        for (i = 0; i < this.borderStyle.length; ++i) {
            buf.append(this.borderStyle[i] == null ? "none" : this.borderStyle[i].getStyle());
            buf.append(' ');
        }
        buf.append(';');
        buf.append(" border-width:");
        for (i = 0; i < this.borderStyle.length; ++i) {
            int w = this.borderStyle[i] == null ? 0 : this.borderStyle[i].getWidth();
            buf.append(' ').append(w).append("px");
        }
        buf.append(';');
        buf.append(" border-color:");
        for (i = 0; i < this.borderStyle.length; ++i) {
            short[] sArray;
            if (this.borderStyle[i] == null) {
                short[] sArray2 = new short[3];
                sArray2[0] = 0;
                sArray2[1] = 0;
                sArray = sArray2;
                sArray2[2] = 0;
            } else {
                sArray = this.borderStyle[i].getRgb();
            }
            short[] rgb = sArray;
            buf.append(' ').append(HTMLHelper.toHexColor(rgb));
        }
        buf.append(';');
    }

    String convertContent(String content) {
        StringBuilder buf = new StringBuilder(content.length() + 100);
        boolean startLine = true;
        for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (ch == ' ' && startLine) {
                buf.append("&nbsp;");
                continue;
            }
            if (ch == '\n') {
                startLine = true;
                buf.append("<br>");
                continue;
            }
            buf.append(ch);
            startLine = false;
        }
        return buf.toString();
    }

    public BorderStyle[] getBorderStyle() {
        return this.borderStyle;
    }

    public int getColspan() {
        return this.colspan;
    }

    public String getContent(boolean showFormulas) {
        if (showFormulas && this.hasFormula) {
            return this.convertContent(this.formula);
        }
        return this.convertContent(this.content);
    }

    public ICellFont getFont() {
        return this.font;
    }

    public String getHalign() {
        return this.halign;
    }

    public String getHtmlStyle(TableModel tm, boolean selectErrorCell) {
        StringBuilder sb = new StringBuilder();
        if (this.halign != null) {
            sb.append("text-align:" + this.halign + ";");
        }
        if (this.valign != null) {
            sb.append("vertical-align:" + this.valign + ";");
        }
        if (this.width != 0) {
            sb.append("width:" + this.width + "px" + ";");
        }
        if (this.rgbBackground == null) {
            this.rgbBackground = WHITE;
        }
        short[] color = this.rgbBackground;
        sb.append("background-color:" + HTMLHelper.toRgbColor(color) + ";");
        if (this.borderStyle != null || this.font != null) {
            sb.append("padding:" + String.valueOf(this.cellPadding) + "px" + ";");
            if (selectErrorCell) {
                sb.append(" border: 2px solid red;");
            } else {
                this.borderToHtml(sb, tm);
            }
            CellModel.fontToHtml(this.font, sb);
        }
        if (this.ident > 0) {
            sb.append("padding-left:" + ((double)this.cellPadding * 0.063 + (double)this.ident) + "em" + ";");
        }
        return sb.toString();
    }

    public static StringBuilder fontToHtml(ICellFont font, StringBuilder buf) {
        if (font == null) {
            return buf;
        }
        if (font.isUnderlined()) {
            buf.append("text-decoration: underline;");
        }
        buf.append("font-family: ").append(font.getName());
        buf.append("; font-size: ").append(font.getSize() + 2);
        if (font.isItalic()) {
            buf.append("; font-style: italic");
        }
        if (font.isBold()) {
            buf.append("; font-weight: bold");
        }
        short[] color = font.getFontColor();
        buf.append("; color: " + HTMLHelper.toHexColor(color) + ";");
        return buf;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIdent() {
        return this.ident;
    }

    public short[] getRgbBackground() {
        return this.rgbBackground;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public String getValign() {
        return this.valign;
    }

    public boolean isReal() {
        return true;
    }

    public void setBorderStyle(BorderStyle bStyle, int dir) {
        if (this.borderStyle == null) {
            this.borderStyle = new BorderStyle[4];
        }
        this.borderStyle[dir] = bStyle;
    }

    public void setBorderStyle(BorderStyle[] borderStyle) {
        this.borderStyle = borderStyle;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFont(ICellFont font) {
        this.font = font;
    }

    public void setHalign(String halign) {
        this.halign = halign;
    }

    public void setIdent(int ident) {
        this.ident = ident;
    }

    public void setRgbBackground(short[] rgbBackground) {
        this.rgbBackground = rgbBackground;
    }

    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void toHtmlString(StringBuilder buf, TableModel table) {
        buf.append("<td");
        this.atttributesToHtml(buf, table);
        buf.append('>').append(this.getContent(false)).append("</td>\n");
    }

    public boolean hasFormula() {
        return this.hasFormula;
    }

    public void setFormula(String formula) {
        this.formula = "=" + formula;
        this.hasFormula = true;
    }

    public String getFormula() {
        return this.formula;
    }
}

