/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.model.ui;

import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.tableeditor.model.ui.BorderStyle;
import org.openl.rules.tableeditor.model.ui.CellModel;
import org.openl.rules.tableeditor.model.ui.CellModelDelegator;
import org.openl.rules.tableeditor.model.ui.TableModel;
import org.openl.util.Log;

public class TableViewer {
    private IGrid grid;
    private IGridRegion reg;

    private void setStyle(ICell cell, CellModel cm) {
        ICellStyle style = cell.getStyle();
        if (style == null) {
            return;
        }
        switch (style.getHorizontalAlignment()) {
            case 3: {
                cm.setHalign("right");
                break;
            }
            case 2: {
                cm.setHalign("center");
                break;
            }
            case 5: {
                cm.setHalign("justify");
            }
        }
        switch (style.getVerticalAlignment()) {
            case 2: {
                cm.setValign("bottom");
                break;
            }
            case 1: {
                cm.setValign("center");
                break;
            }
            case 0: {
                cm.setValign("top");
            }
        }
        if (style.getIdent() > 0) {
            cm.setIdent(style.getIdent());
        }
        short[] rgb = style.getFillForegroundColor();
        cm.setRgbBackground(rgb);
        cm.setFont(cell.getFont());
    }

    public static String showTable(TableModel tm, boolean showGrid) {
        StringBuilder buf = new StringBuilder(1000);
        tm.toHtmlString(buf, showGrid);
        return buf.toString();
    }

    public TableViewer() {
    }

    public TableViewer(IGrid grid, IGridRegion reg) {
        this.grid = grid;
        this.reg = reg;
    }

    CellModel buildCell(ICell cell, CellModel cm) {
        String formattedValue;
        cm.setColspan(this.getColSpan(cell));
        cm.setRowspan(this.getRowSpan(cell));
        if (cm.getRow() == 0) {
            cm.setWidth(this.getWidth(cell));
        }
        if ((formattedValue = ((FormattedCell)cell).getFormattedValue()) != null && formattedValue.trim().length() != 0) {
            cm.setContent(formattedValue);
            if (cell.getFormula() != null) {
                cm.setFormula(cell.getFormula());
            }
        }
        this.setStyle(cell, cm);
        return cm;
    }

    public TableModel buildModel(IGridTable gt) {
        int h = IGridRegion.Tool.height((IGridRegion)this.reg);
        int w = IGridRegion.Tool.width((IGridRegion)this.reg);
        TableModel tm = new TableModel(w, h, gt);
        for (int row = this.reg.getTop(); row <= this.reg.getBottom(); ++row) {
            for (int column = this.reg.getLeft(); column <= this.reg.getRight(); ++column) {
                int c = column - this.reg.getLeft();
                int r = row - this.reg.getTop();
                if (tm.hasCell(r, c)) continue;
                ICell cell = this.grid.getCell(column, row);
                CellModel cm = this.buildCell(cell, new CellModel(r, c));
                tm.addCell(cm, r, c);
                if (cm.getColspan() <= 1 && cm.getRowspan() <= 1) continue;
                CellModelDelegator cmd = new CellModelDelegator(cm);
                for (int i = 0; i < cm.getRowspan(); ++i) {
                    for (int j = 0; j < cm.getColspan(); ++j) {
                        if (i == 0 && j == 0) continue;
                        tm.addCell(cmd, r + i, c + j);
                    }
                }
            }
        }
        this.setGrid(tm);
        return tm;
    }

    BorderStyle getBorderStyle(ICellStyle cs, int side) {
        short[] sArray;
        short[] bss = cs.getBorderStyle();
        short xlsStyle = bss == null ? (short)0 : bss[side];
        short[][] rgbb = cs.getBorderRGB();
        if (rgbb == null) {
            short[] sArray2 = new short[3];
            sArray2[0] = 0;
            sArray2[1] = 0;
            sArray = sArray2;
            sArray2[2] = 0;
        } else {
            sArray = rgbb[side];
        }
        short[] rgb = sArray;
        BorderStyle bs = new BorderStyle();
        bs.setRgb(rgb);
        switch (xlsStyle) {
            case 0: {
                return BorderStyle.NONE;
            }
            case 3: 
            case 9: 
            case 11: {
                bs.setWidth(1);
                bs.setStyle("dashed");
                break;
            }
            case 4: {
                bs.setWidth(1);
                bs.setStyle("dotted");
                break;
            }
            case 6: {
                bs.setWidth(1);
                bs.setStyle("double");
                break;
            }
            case 1: {
                bs.setWidth(1);
                bs.setStyle("solid");
                break;
            }
            case 5: {
                bs.setWidth(2);
                bs.setStyle("solid");
                break;
            }
            case 7: {
                bs.setWidth(1);
                bs.setStyle("dotted");
                break;
            }
            case 2: {
                bs.setWidth(2);
                bs.setStyle("solid");
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                bs.setWidth(2);
                bs.setStyle("dashed");
                break;
            }
            default: {
                Log.warn((Object)("Unknown border style: " + xlsStyle));
            }
        }
        return bs;
    }

    int getColSpan(ICell cell) {
        IGridRegion gr = cell.getRegion();
        if (gr == null) {
            return 1;
        }
        return IGridRegion.Tool.width((IGridRegion)IGridRegion.Tool.intersect((IGridRegion)this.reg, (IGridRegion)gr));
    }

    int getRowSpan(ICell cell) {
        IGridRegion gr = cell.getRegion();
        if (gr == null) {
            return 1;
        }
        return IGridRegion.Tool.height((IGridRegion)IGridRegion.Tool.intersect((IGridRegion)this.reg, (IGridRegion)gr));
    }

    public int getWidth(ICell cell) {
        IGridRegion gr = cell.getRegion();
        if (gr == null) {
            return this.grid.getColumnWidth(cell.getColumn());
        }
        int w = 0;
        gr = IGridRegion.Tool.intersect((IGridRegion)gr, (IGridRegion)this.reg);
        for (int c = gr.getLeft(); c <= gr.getRight(); ++c) {
            w += this.grid.getColumnWidth(c);
        }
        return w;
    }

    short[] rgb(BorderStyle bs1, BorderStyle bs2) {
        if (bs1 == null && bs2 == null) {
            return new short[]{0, 0, 0};
        }
        return bs1 == null ? bs2.getRgb() : (bs2 == null ? bs1.getRgb() : (bs1 == BorderStyle.NONE ? bs2.getRgb() : bs1.getRgb()));
    }

    void setGrid(TableModel tm) {
        int width = IGridRegion.Tool.width((IGridRegion)this.reg);
        for (int i = 0; i <= width; ++i) {
            this.setVerticalBorder(i, tm);
        }
        int height = IGridRegion.Tool.height((IGridRegion)this.reg);
        for (int i = 0; i <= height; ++i) {
            this.setHorizontalBorder(i, tm);
        }
    }

    void setHorizontalBorder(int row, TableModel tm) {
        int width = IGridRegion.Tool.width((IGridRegion)this.reg);
        int left = this.reg.getLeft();
        int top = this.reg.getTop();
        block5: for (int i = 0; i < width; ++i) {
            CellModel cmBottom;
            ICellStyle ts = row + top - 1 < 0 ? null : this.grid.getCell(i + left, row + top - 1).getStyle();
            ICellStyle bs = this.grid.getCell(i + left, row + top).getStyle();
            CellModel cmTop = ts == null ? null : tm.findCellModel(i, row - 1, 2);
            CellModel cellModel = cmBottom = bs == null ? null : tm.findCellModel(i, row, 0);
            if (cmTop == null && cmBottom == null) continue;
            BorderStyle tStyle = ts != null ? this.getBorderStyle(ts, 2) : null;
            BorderStyle bStyle = bs != null ? this.getBorderStyle(bs, 0) : null;
            int W = this.width(tStyle, bStyle);
            String style = this.style(tStyle, bStyle);
            short[] rgb = this.rgb(tStyle, bStyle);
            BorderStyle bstyle = new BorderStyle(W, style, rgb);
            switch (W) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    if (cmTop == null) {
                        cmBottom.setBorderStyle(bstyle, 0);
                        continue block5;
                    }
                    cmTop.setBorderStyle(bstyle, 2);
                    continue block5;
                }
                case 2: {
                    if (cmTop == null) {
                        cmBottom.setBorderStyle(bstyle, 0);
                        continue block5;
                    }
                    if (cmBottom == null) {
                        cmTop.setBorderStyle(bstyle, 2);
                        continue block5;
                    }
                    bstyle.setWidth(1);
                    cmBottom.setBorderStyle(bstyle, 0);
                    cmTop.setBorderStyle(bstyle, 2);
                }
            }
        }
    }

    void setVerticalBorder(int column, TableModel tm) {
        int height = IGridRegion.Tool.height((IGridRegion)this.reg);
        int left = this.reg.getLeft();
        int top = this.reg.getTop();
        block5: for (int i = 0; i < height; ++i) {
            CellModel cmRight;
            ICellStyle ls = column + left - 1 < 0 ? null : this.grid.getCell(column + left - 1, i + top).getStyle();
            ICellStyle rs = column + left - 1 < 0 ? null : this.grid.getCell(column + left, i + top).getStyle();
            CellModel cmLeft = ls == null ? null : tm.findCellModel(column - 1, i, 1);
            CellModel cellModel = cmRight = rs == null ? null : tm.findCellModel(column, i, 3);
            if (cmLeft == null && cmRight == null) continue;
            BorderStyle lStyle = ls != null ? this.getBorderStyle(ls, 1) : null;
            BorderStyle rStyle = rs != null ? this.getBorderStyle(rs, 3) : null;
            int W = this.width(lStyle, rStyle);
            String style = this.style(lStyle, rStyle);
            short[] rgb = this.rgb(lStyle, rStyle);
            BorderStyle bstyle = new BorderStyle(W, style, rgb);
            switch (W) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    if (cmLeft == null) {
                        cmRight.setBorderStyle(bstyle, 3);
                        continue block5;
                    }
                    cmLeft.setBorderStyle(bstyle, 1);
                    continue block5;
                }
                case 2: {
                    if (cmLeft == null) {
                        cmRight.setBorderStyle(bstyle, 3);
                        continue block5;
                    }
                    if (cmRight == null) {
                        cmLeft.setBorderStyle(bstyle, 1);
                        continue block5;
                    }
                    bstyle.setWidth(1);
                    cmRight.setBorderStyle(bstyle, 3);
                    cmLeft.setBorderStyle(bstyle, 1);
                }
            }
        }
    }

    String style(BorderStyle bs1, BorderStyle bs2) {
        if (bs1 == null && bs2 == null) {
            return "none";
        }
        return bs1 == null ? bs2.getStyle() : (bs2 == null ? bs1.getStyle() : (bs1 == BorderStyle.NONE ? bs2.getStyle() : bs1.getStyle()));
    }

    int width(BorderStyle bs1, BorderStyle bs2) {
        if (bs1 == null && bs2 == null) {
            return 0;
        }
        return bs1 == null ? bs2.getWidth() : (bs2 == null ? bs1.getWidth() : Math.max(bs1.getWidth(), bs2.getWidth()));
    }
}

