/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.model.ui.util;

public class StringHighlighter {
    private final String BOLD_OPEN = "<b>";
    private final String BOLD_CLOSE = "</b>";
    private String[] tokensToHighlight;
    private String currentToken;
    private String text;
    private int lastSelected = -1;

    public StringHighlighter(String[] tokens, String src) {
        this.tokensToHighlight = tokens;
        this.text = src;
    }

    private int findTokenFromPos(int startPos) {
        int textLength = this.text.length();
        this.lastSelected = -1;
        for (int i = this.tokensToHighlight.length - 1; i >= 0; --i) {
            int idx = this.findToken(this.tokensToHighlight[i].toLowerCase(), startPos);
            if (idx < 0 || idx >= textLength) continue;
            this.lastSelected = i;
            textLength = idx;
        }
        if (this.lastSelected < 0) {
            return -1;
        }
        this.currentToken = this.text.substring(textLength, textLength + this.tokensToHighlight[this.lastSelected].length());
        return textLength;
    }

    private int findToken(String token, int startPos) {
        String text = this.text;
        int tokenIndex = 0;
        tokenIndex = text.toLowerCase().indexOf(token, startPos);
        return tokenIndex;
    }

    public String highlightStringsInText() {
        StringBuffer buf = new StringBuffer();
        int startPos = 0;
        while (true) {
            int nextStart;
            if ((nextStart = this.findTokenFromPos(startPos)) < 0) {
                buf.append(this.text.substring(startPos));
                return buf.toString();
            }
            buf.append(this.text.substring(startPos, nextStart));
            buf.append("<b>");
            buf.append(this.currentToken);
            buf.append("</b>");
            startPos = nextStart + this.tokensToHighlight[this.lastSelected].length();
        }
    }
}

