/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.renderkit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.constraints.Constraint;
import org.openl.rules.table.constraints.Constraints;
import org.openl.rules.table.constraints.LessThanConstraint;
import org.openl.rules.table.constraints.MoreThanConstraint;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.DefaultPropertyDefinitions;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.rules.table.ui.filters.IGridFilter;
import org.openl.rules.table.xls.XlsUrlParser;
import org.openl.rules.tableeditor.model.ui.ActionLink;
import org.openl.rules.tableeditor.model.ui.CellModel;
import org.openl.rules.tableeditor.model.ui.ICellModel;
import org.openl.rules.tableeditor.model.ui.TableModel;
import org.openl.rules.tableeditor.renderkit.TableEditor;
import org.openl.rules.tableeditor.renderkit.TableProperty;
import org.openl.rules.tableeditor.util.WebUtil;
import org.openl.util.EnumUtils;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLRenderer {
    public static final String NL = "\n";

    protected Set getResourcesWritten() {
        Map requestMap = FacesUtils.getRequestMap();
        HashSet resources = (HashSet)requestMap.get("_tableEditorResources");
        if (resources == null) {
            resources = new HashSet();
            requestMap.put("_tableEditorResources", resources);
        }
        return resources;
    }

    public String render(TableEditor editor) {
        return this.render(editor, false, null, null, null);
    }

    public String render(TableEditor editor, boolean inner, String cellToEdit, List<ActionLink> actionLinks, String errorCell) {
        String mode;
        StringBuilder result = new StringBuilder();
        result.append("<div>").append(this.renderCSS("css/common.css")).append(this.renderCSS("css/menu.css")).append(this.renderCSS("css/toolbar.css")).append(this.renderCSS("css/datepicker.css")).append(this.renderCSS("css/multiselect.css")).append(this.renderCSS("css/tooltip.css"));
        if (!"prototype".equalsIgnoreCase(editor.getExcludeScripts())) {
            result.append(this.renderJS("js/prototype/prototype-1.6.1.js"));
        }
        result.append(this.renderJS("js/ScriptLoader.js")).append(this.renderJS("js/AjaxHelper.js")).append(this.renderJS("js/IconManager.js")).append(this.renderJS("js/TableEditor.js")).append(this.renderJS("js/initTableEditor.js")).append(this.renderJS("js/BaseEditor.js")).append(this.renderJS("js/BaseTextEditor.js"));
        if (!inner) {
            result.append("<div id='").append(editor.getId()).append("' class='te_'>");
        }
        if ((mode = editor.getMode()) == null || mode.equals("view")) {
            result.append(this.renderViewer(editor, actionLinks, errorCell));
        } else if (mode.equals("edit")) {
            result.append(this.renderEditor(editor, cellToEdit, errorCell));
        }
        if (!inner) {
            result.append("</div>");
        }
        result.append("</div>");
        return result.toString();
    }

    protected String renderActionMenu(String menuId, boolean editable, List<ActionLink> actionLinks) {
        StringBuilder result = new StringBuilder();
        String editLink = "<tr><td><a href=\"javascript:triggerEdit('" + menuId.replaceFirst("_menu", "") + "','" + WebUtil.internalPath("ajax/edit") + "')\">Edit</a></td></tr>";
        String menuBegin = "<div id=\"" + menuId + "\" style=\"display:none;\">" + "<table cellpadding=\"1px\">" + (editable ? editLink : "");
        String menuEnd = "</table></div>";
        result.append(menuBegin).append(actionLinks == null ? "" : this.renderAddActionLinks(actionLinks)).append(menuEnd);
        return result.toString();
    }

    protected String renderAddActionLinks(List<ActionLink> links) {
        if (links == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (ActionLink link : links) {
            result.append("<tr><td>").append("<a href=\"").append(link.getAction()).append("\">").append(link.getName()).append("</a>").append("</td></tr>");
        }
        return result.toString();
    }

    public String renderCSS(String cssPath) {
        Set resources = this.getResourcesWritten();
        if (resources.add(cssPath)) {
            StringBuilder result = new StringBuilder();
            result.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(WebUtil.internalPath(cssPath)).append("\"></link>");
            return result.toString();
        }
        return "";
    }

    public String getSingleSelectComponentCode(String componentId, String[] values, String[] displayValues, String value) {
        String choisesString = "\"" + StringUtils.join((Object[])values, (String)"\", \"") + "\"";
        String displayValuesString = "\"" + StringUtils.join((Object[])displayValues, (String)"\", \"") + "\"";
        String params = String.format("{choices : [%s], displayValues : [%s]}", choisesString, displayValuesString);
        String id = componentId == null ? "" : componentId;
        String jsCode = String.format("new DropdownEditor('', '%s', %s, '%s', '');", id, params, StringEscapeUtils.escapeJavaScript((String)value));
        return jsCode;
    }

    public String getMultiSelectComponentCode(String componentId, String[] values, String[] displayValues, String value) {
        String choisesString = "\"" + StringUtils.join((Object[])values, (String)"\", \"") + "\"";
        String displayValuesString = "\"" + StringUtils.join((Object[])displayValues, (String)"\", \"") + "\"";
        String params = String.format("{choices : [%s], displayValues : [%s], separator : \",\", separatorEscaper : \"&#92;&#92;&#92;&#92;\"}", choisesString, displayValuesString);
        String id = componentId == null ? "" : componentId;
        String jsCode = String.format("new MultiselectEditor('', '%s', %s, '%s', '');", id, params, StringEscapeUtils.escapeJavaScript((String)value));
        return jsCode;
    }

    protected String renderEditor(TableEditor editor, String cellToEdit, String errorCell) {
        StringBuilder result = new StringBuilder();
        cellToEdit = cellToEdit == null ? "" : cellToEdit;
        String tableId = editor.getId() + "_table";
        String editorJsVar = "_te" + editor.getId();
        String beforeSave = this.getEditorJSAction(editor.getOnBeforeSave());
        String afterSave = this.getEditorJSAction(editor.getOnAfterSave());
        String saveFailure = this.getEditorJSAction(editor.getOnSaveFailure());
        String actions = "{beforeSave:" + beforeSave + ",afterSave:" + afterSave + ",saveFailure:" + saveFailure + "}";
        result.append(this.renderJSBody("var " + editorJsVar + ";")).append(this.renderEditorToolbar(editor.getId(), editorJsVar)).append(this.renderJS("js/tooltip.js")).append(this.renderJS("js/validation.js")).append(this.renderJS("js/datepicker.packed.js")).append(this.renderJS("js/TextEditor.js")).append(this.renderJS("js/MultiLineEditor.js")).append(this.renderJS("js/NumericEditor.js")).append(this.renderJS("js/DropdownEditor.js")).append(this.renderJS("js/FormulaEditor.js")).append(this.renderJS("js/BooleanEditor.js")).append(this.renderJS("js/DateEditor.js")).append(this.renderJS("js/MultiselectEditor.js")).append(this.renderJS("js/ArrayEditor.js"));
        result.append(this.renderPropsEditor(editor.getId(), editor.getTable(), "edit", editor.isCollapseProps()));
        result.append("<div id=\"").append(tableId).append("\"></div>");
        result.append(this.renderJSBody(editorJsVar + " = initTableEditor(\"" + editor.getId() + "\", \"" + WebUtil.internalPath("ajax/") + "\",\"" + cellToEdit + "\"," + actions + ");"));
        return result.toString();
    }

    protected String getEditorJSAction(String action) {
        return StringUtils.isBlank((String)action) ? "''" : "function() {" + action + "}";
    }

    protected String renderEditorToolbar(String editorId, String editorJsVar) {
        StringBuilder result = new StringBuilder();
        String toolbarItemSeparator = "<img src=" + WebUtil.internalPath("img/toolbarSeparator.gif") + " class=\"item_separator\"></img>";
        result.append("<div class=\"te_toolbar\">").append(this.renderEditorToolbarItem(editorId + "_save_all", editorJsVar, "img/Save.gif", "save()", "Save")).append(this.renderEditorToolbarItem(editorId + "_undo", editorJsVar, "img/Undo.gif", "undoredo()", "Undo")).append(this.renderEditorToolbarItem(editorId + "_redo", editorJsVar, "img/Redo.gif", "undoredo(true)", "Redo")).append(toolbarItemSeparator).append(this.renderEditorToolbarItem(editorId + "_insert_row_before", editorJsVar, "img/insert_row.gif", "doTableOperation(TableEditor.Operations.INSERT_ROW_BEFORE)", "Insert row before")).append(this.renderEditorToolbarItem(editorId + "_remove_row", editorJsVar, "img/delete_row.gif", "doTableOperation(TableEditor.Operations.REMOVE_ROW)", "Remove row")).append(toolbarItemSeparator).append(this.renderEditorToolbarItem(editorId + "_insert_column_before", editorJsVar, "img/insert_column.gif", "doTableOperation(TableEditor.Operations.INSERT_COLUMN_BEFORE)", "Insert column before")).append(this.renderEditorToolbarItem(editorId + "_remove_column", editorJsVar, "img/delete_column.gif", "doTableOperation(TableEditor.Operations.REMOVE_COLUMN)", "Remove column")).append(toolbarItemSeparator).append(this.renderEditorToolbarItem(editorId + "_align_left", editorJsVar, "img/alLeft.gif", "setAlignment('left')", "Align left")).append(this.renderEditorToolbarItem(editorId + "_align_center", editorJsVar, "img/alCenter.gif", "setAlignment('center')", "Align center")).append(this.renderEditorToolbarItem(editorId + "_align_right", editorJsVar, "img/alRight.gif", "setAlignment('right')", "Align right")).append(toolbarItemSeparator).append(this.renderEditorToolbarItem(editorId + "_decrease_indent", editorJsVar, "img/indent_left.gif", "indent('-1')", "Decrease indent")).append(this.renderEditorToolbarItem(editorId + "_increase_indent", editorJsVar, "img/indent_right.gif", "indent('1')", "Increase indent")).append(toolbarItemSeparator).append(this.renderEditorToolbarItem(editorId + "_help", null, "img/help.gif", "window.open('" + WebUtil.internalPath("docs/help.html") + "');", "Help")).append("</div>");
        return result.toString();
    }

    protected String renderEditorToolbarItem(String itemId, String editor, String imgSrc, String action, String title) {
        editor = editor == null || editor.equals("") ? "" : editor + ".";
        StringBuilder result = new StringBuilder();
        result.append("<img id=\"").append(itemId).append("\" src=\"").append(WebUtil.internalPath(imgSrc)).append("\" title=\"").append(title).append("\" onclick=\"").append(editor).append(action).append("\" onmouseover=\"this.className='item_over'\"").append(" onmouseout=\"this.className='item_enabled'\"").append("></img>");
        return result.toString();
    }

    public String renderJS(String jsPath) {
        Set resources = this.getResourcesWritten();
        if (resources.add(jsPath)) {
            StringBuilder result = new StringBuilder();
            result.append("<script type=\"text/javascript\" src=\"").append(WebUtil.internalPath(jsPath)).append("\"></script>");
            return result.toString();
        }
        return "";
    }

    public String renderJSBody(String jsBody) {
        Set resources = this.getResourcesWritten();
        if (resources.add(jsBody)) {
            StringBuilder result = new StringBuilder();
            result.append("<script type=\"text/javascript\">").append(jsBody).append("</script>");
            return result.toString();
        }
        return "";
    }

    protected String renderViewer(TableEditor editor, List<ActionLink> actionLinks, String errorCell) {
        StringBuilder result = new StringBuilder();
        if (editor.getTable() != null) {
            result.append(this.renderPropsEditor(editor.getId(), editor.getTable(), "view", editor.isCollapseProps()));
        }
        if (editor.getTable() != null) {
            IGridFilter[] iGridFilterArray;
            if (editor.getFilter() == null) {
                iGridFilterArray = null;
            } else {
                IGridFilter[] iGridFilterArray2 = new IGridFilter[1];
                iGridFilterArray = iGridFilterArray2;
                iGridFilterArray2[0] = editor.getFilter();
            }
            IGridFilter[] filters = iGridFilterArray;
            TableModel tableModel = TableModel.initializeTableModel(editor.getTable().getGridTable(editor.getView()), filters);
            if (tableModel != null) {
                String menuId = editor.getId() + "_menu";
                TableRenderer tableRenderer = new TableRenderer(tableModel);
                tableRenderer.setCellIdPrefix(editor.getId() + "_cell-");
                if (editor.isEditable() || actionLinks != null && !actionLinks.isEmpty()) {
                    result.append(this.renderJS("js/popup/popupmenu.js")).append(this.renderJS("js/tableEditorMenu.js")).append(tableRenderer.renderWithMenu(editor, menuId, errorCell)).append(this.renderActionMenu(menuId, editor.isEditable(), actionLinks));
                } else {
                    result.append(tableRenderer.render(editor.isShowFormulas()));
                }
            }
        }
        return result.toString();
    }

    protected String renderPropsEditor(String editorId, IOpenLTable table, String mode, boolean collapseProps) {
        String tableType = table.getType();
        if (!(tableType == null || tableType.equals(XlsNodeTypes.XLS_OTHER.toString()) || tableType.equals(XlsNodeTypes.XLS_ENVIRONMENT.toString()) || tableType.equals(XlsNodeTypes.XLS_PROPERTIES.toString()))) {
            ITableProperties props = table.getProperties();
            return new PropertyRenderer(editorId + "_props", props, mode, collapseProps, tableType).renderProperties();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PropertyRenderer {
        private List<TableProperty> listProperties = new ArrayList<TableProperty>();
        private StringBuilder result;
        private String mode;
        private ITableProperties props;
        private String propsId;
        private boolean collapsed;
        private String tableType;

        public PropertyRenderer(String propsId, ITableProperties props, String view, boolean collapsed, String tableType) {
            this.propsId = propsId == null ? "" : propsId;
            this.props = props;
            this.mode = view;
            this.tableType = tableType;
            this.listProperties = this.initPropertiesList();
            this.result = new StringBuilder();
            this.collapsed = collapsed;
        }

        private List<TableProperty> initPropertiesList() {
            TablePropertyDefinition[] propDefinitions;
            ArrayList<TableProperty> listProp = new ArrayList<TableProperty>();
            for (TablePropertyDefinition propDefinition : propDefinitions = DefaultPropertyDefinitions.getDefaultDefinitions()) {
                String name = propDefinition.getName();
                String displayName = propDefinition.getDisplayName();
                Object value = this.props != null ? this.props.getPropertyValue(propDefinition.getName()) : null;
                Class type = propDefinition.getType() == null ? String.class : propDefinition.getType().getInstanceClass();
                InheritanceLevel inheritanceLevel = this.props.getPropertyLevelDefinedOn(name);
                String group = propDefinition.getGroup();
                String format = propDefinition.getFormat();
                Constraints constraints = propDefinition.getConstraints();
                String description = propDefinition.getDescription();
                boolean system = propDefinition.isSystem();
                if (!PropertiesChecker.isPropertySuitableForTableType((String)name, (String)this.tableType)) continue;
                TableProperty prop = new TableProperty.TablePropertyBuilder(name, type).value(value).displayName(displayName).group(group).format(format).constraints(constraints).description(description).system(system).inheritanceLevel(inheritanceLevel).build();
                listProp.add(prop);
            }
            return listProp;
        }

        private TableProperty getProperty(String name) {
            for (TableProperty property : this.listProperties) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
            return null;
        }

        private Map<String, List<TableProperty>> groupProps(List<TableProperty> props) {
            LinkedHashMap<String, List<TableProperty>> groupProps = new LinkedHashMap<String, List<TableProperty>>();
            for (TableProperty prop : props) {
                String group = prop.getGroup();
                ArrayList<TableProperty> groupList = (ArrayList<TableProperty>)groupProps.get(group);
                if (groupList == null) {
                    groupList = new ArrayList<TableProperty>();
                    groupProps.put(group, groupList);
                }
                if (groupList.contains(prop)) continue;
                groupList.add(prop);
            }
            return groupProps;
        }

        public String renderProperties() {
            this.result.append(HTMLRenderer.this.renderCSS("css/properties.css"));
            this.result.append("<table cellspacing='0' cellpadding='0' class='te_props'>");
            this.result.append("<tr><td class='te_props_header'>Properties");
            this.renderHideButton(this.propsId);
            this.result.append("</td></tr><tr><td><div id=" + this.propsId + " class='te_props_propstable' style='display: none;'>");
            this.result.append("<table cellspacing='1' cellpadding='1'>");
            this.buildPropsTable();
            this.result.append("</table></div></td></tr></table>");
            if (!this.collapsed) {
                this.result.append(HTMLRenderer.this.renderJSBody("$('" + this.propsId + "').show()"));
            }
            return this.result.toString();
        }

        private void buildPropsTable() {
            Map<String, List<TableProperty>> groupProps = this.groupProps(this.listProperties);
            int groupSize = groupProps.size();
            int numToDivide = this.getNumToDivideColumns(groupSize);
            int i = 0;
            Set<String> groupKeys = groupProps.keySet();
            for (String group : groupKeys) {
                if (i == 0) {
                    this.result.append("<tr>");
                }
                if (i == numToDivide) {
                    this.result.append("</tr>");
                    this.result.append("<tr>");
                }
                this.result.append("<td valign='top' class='te_props_group'>");
                this.fillPropsGroup(group, this.mode);
                this.result.append("</td>");
                if (i == groupSize - 1) {
                    this.result.append("</tr>");
                }
                ++i;
            }
        }

        private int getNumToDivideColumns(int groupSize) {
            int numToDivide = 0;
            numToDivide = groupSize % 2 == 0 ? groupSize / 2 : (groupSize + 1) / 2;
            return numToDivide;
        }

        private void fillPropsGroup(String groupKey, String mode) {
            Map<String, List<TableProperty>> groupProps = this.groupProps(this.listProperties);
            List<TableProperty> groupList = groupProps.get(groupKey);
            String groupId = this.propsId + "_group-" + groupKey;
            this.result.append("<div class='te_props_groupheader'>");
            this.result.append(groupKey);
            this.renderHideButton(groupId);
            this.result.append("</div>");
            this.result.append("<div id='" + groupId + "' class='te_props_grouptable'>");
            this.result.append("<table>");
            for (TableProperty prop : groupList) {
                this.insertProp(prop);
            }
            this.result.append("</table></div>");
        }

        private void insertProp(TableProperty prop) {
            String inheritPropStyleClass = "";
            if (prop.isModuleLevelProperty() || prop.isCategoryLevelProperty()) {
                inheritPropStyleClass = " te_props_prop_inherited";
            }
            this.result.append("<tr class='te_props_prop" + inheritPropStyleClass + "'>");
            this.insertPropLabel(prop.getDisplayName());
            this.insertPropValue(prop, this.mode);
            this.insertPropertiesTableLink(prop, this.mode);
            this.result.append("</tr>");
        }

        private void insertPropValue(TableProperty prop, String mode) {
            if ("edit".equals(mode)) {
                String propId = this.getPropId(prop);
                if (prop.isSystem() || !prop.canBeOverridenInTable() || "version".equalsIgnoreCase(prop.getName())) {
                    this.insertText(prop, propId, true);
                } else {
                    this.insertInput(prop, propId, true);
                }
            } else {
                this.insertText(prop);
            }
        }

        private void insertPropertiesTableLink(TableProperty prop, String mode) {
            this.result.append("<td>");
            String propsTableUri = this.getProprtiesTablePageUrl(prop, mode);
            if (propsTableUri != null) {
                String imgUp = WebUtil.internalPath("img/up.gif");
                this.result.append("<a href='" + propsTableUri + "' title=''><img src='" + imgUp + "' title='Go to Properties table' alt='Go to Properties table' /></a>");
            }
            this.result.append("</td>");
        }

        private String getProprtiesTablePageUrl(TableProperty prop, String mode) {
            String url = null;
            ILogicalTable propertiesTable = null;
            if (prop.isModuleLevelProperty()) {
                propertiesTable = this.props.getModulePropertiesTable();
            } else if (prop.isCategoryLevelProperty()) {
                propertiesTable = this.props.getCategoryPropertiesTable();
            }
            if (propertiesTable != null) {
                String tableUri = propertiesTable.getSource().getUri();
                url = "?uri=" + StringTool.encodeURL((String)tableUri);
                if ("edit".equals(mode)) {
                    url = url + "&mode=edit";
                }
            }
            return url;
        }

        private void renderHideButton(String idToHide) {
            String imgCollapseSrc = WebUtil.internalPath("img/arrow_right.gif");
            String imgExpandSrc = WebUtil.internalPath("img/arrow_down.gif");
            this.result.append(" <img src='" + imgCollapseSrc + "' onclick=\"$('" + idToHide + "').toggle();this.src=(this.title == 'Hide' ? '" + imgExpandSrc + "' : '" + imgCollapseSrc + "');" + "this.title=(this.title == 'Hide' ? 'Show' : 'Hide');\"" + " title='Hide' class='te_props_hidebutton' />");
        }

        private String getPropId(TableProperty prop) {
            return this.propsId + "_prop-" + prop.getName();
        }

        private void insertInput(TableProperty prop, String id, boolean showTooltip) {
            boolean inserted = true;
            String propValue = prop.getStringValue();
            if (prop.isString() || prop.isDouble()) {
                this.insertTextbox(prop, id);
            } else if (prop.isStringArray()) {
                this.insertTextbox(prop, id);
            } else if (prop.isDate()) {
                this.insertCalendar(prop, id);
            } else if (prop.isBoolean()) {
                this.insertCheckbox(propValue, id);
            } else if (prop.isEnum()) {
                this.insertSingleSelectForEnum(prop, id);
            } else if (prop.isEnumArray()) {
                this.insertMultiSelectForEnum(prop, id);
            } else {
                inserted = false;
            }
            if (showTooltip && inserted) {
                this.insertTooltip(id, prop.getDescription());
            }
        }

        private void insertTooltip(String propId, String description) {
            this.result.append(HTMLRenderer.this.renderJSBody("new Tooltip('_" + propId + "','" + description + "',{skin:'green'})"));
        }

        private void insertCalendar(TableProperty prop, String id) {
            String value = prop.getStringValue();
            Constraints constraints = prop.getConstraints();
            this.result.append("<td id='" + id + "' class='te_props_proptextinput'></td>").append(HTMLRenderer.this.renderJSBody("new DateEditor('','" + id + "','','" + StringEscapeUtils.escapeJavaScript((String)value) + "','')"));
            for (Constraint constraint : constraints.getAll()) {
                if (!(constraint instanceof LessThanConstraint) && !(constraint instanceof MoreThanConstraint)) continue;
                String validator = constraint instanceof LessThanConstraint ? "lessThan" : "moreThan";
                String compareToField = (String)constraint.getParams()[0];
                String compareToFieldId = "_" + id.replaceFirst(prop.getName() + "(?=$)", compareToField);
                TableProperty compareToProperty = this.getProperty(compareToField);
                String compareToPropertyDisplayName = compareToProperty == null ? "" : compareToProperty.getDisplayName();
                this.result.append(HTMLRenderer.this.renderJSBody("new Validation('_" + id + "', '" + validator + "', 'blur', {compareToFieldId:'" + compareToFieldId + "',messageParams:'" + compareToPropertyDisplayName + "'})"));
            }
        }

        private void insertSingleSelect(String componentId, String[] values, String[] displayValues, String value) {
            String jsCode = HTMLRenderer.this.getSingleSelectComponentCode(componentId, values, displayValues, value);
            this.result.append("<td id='" + componentId + "' class='te_props_proptextinput'></td>").append(HTMLRenderer.this.renderJSBody(jsCode));
        }

        private void insertSingleSelectForEnum(TableProperty prop, String id) {
            Class<?> instanceClass = prop.getType();
            String value = prop.getStringValue();
            String[] values = EnumUtils.getNames(instanceClass);
            String[] displayValues = EnumUtils.getValues(instanceClass);
            this.insertSingleSelect(id, values, displayValues, value);
        }

        private void insertMultiSelectForEnum(TableProperty prop, String id) {
            Class<?> instanceClass = prop.getType().getComponentType();
            String valueString = prop.getStringValue();
            String[] values = EnumUtils.getNames(instanceClass);
            String[] displayValues = EnumUtils.getValues(instanceClass);
            this.insertMultiSelect(id, values, displayValues, valueString);
        }

        private void insertMultiSelect(String componentId, String[] values, String[] displayValues, String value) {
            String jsCode = HTMLRenderer.this.getMultiSelectComponentCode(componentId, values, displayValues, value);
            this.result.append("<td id='" + componentId + "' class='te_props_proptextinput'></td>").append(HTMLRenderer.this.renderJSBody(jsCode));
        }

        private void insertTextbox(TableProperty prop, String id) {
            String value = prop.getStringValue();
            this.insertTextbox(value, id);
        }

        private void insertTextbox(String value, String id) {
            this.result.append("<td id='" + id + "' class='te_props_proptextinput'></td>").append(HTMLRenderer.this.renderJSBody("new TextEditor('','" + id + "','','" + StringEscapeUtils.escapeJavaScript((String)value) + "','')"));
        }

        private void insertCheckbox(String value, String id) {
            Boolean bValue = new Boolean(value);
            if (value == null) {
                bValue = false;
            }
            this.result.append("<td id='" + id + "'></td>").append(HTMLRenderer.this.renderJSBody("new BooleanEditor('','" + id + "','','" + bValue + "','')"));
        }

        private void insertPropLabel(String displayName) {
            this.result.append("<td class='te_props_proplabel'>" + displayName + ":</td>");
        }

        private void insertText(TableProperty prop) {
            this.insertText(prop, null, false);
        }

        private void insertText(TableProperty prop, String id, boolean showTooltip) {
            String propValue = prop.getDisplayValue();
            this.result.append("<td class='te_props_propvalue'><span" + (StringUtils.isNotBlank((String)id) ? " id='_" + id + "'" : "") + ">" + propValue + "</span></td>");
            if (showTooltip) {
                this.insertTooltip(id, prop.getDescription());
            }
        }
    }

    public static class TableRenderer {
        private final TableModel tableModel;
        private String cellIdPrefix;

        public TableRenderer(TableModel tableModel) {
            this.tableModel = tableModel;
        }

        public String render(boolean showFormulas) {
            return this.render(null, false, showFormulas, null);
        }

        public String render(String extraTDText, boolean embedCellURI, boolean showFormulas, String errorCell) {
            String tdPrefix = "<td";
            if (extraTDText != null) {
                tdPrefix = tdPrefix + " ";
                tdPrefix = tdPrefix + extraTDText;
            }
            String prefix = this.cellIdPrefix != null ? this.cellIdPrefix : "_cell-";
            IGridTable table = this.tableModel.getGridTable();
            StringBuilder s = new StringBuilder();
            s.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
            for (int i = 0; i < this.tableModel.getCells().length; ++i) {
                s.append("<tr>\n");
                for (int j = 0; j < this.tableModel.getCells()[i].length; ++j) {
                    String cellContent;
                    ICellModel cell = this.tableModel.getCells()[i][j];
                    if (cell == null || !cell.isReal()) continue;
                    String cellUri = null;
                    if (table != null) {
                        cellUri = table.getUri(j, i);
                    }
                    s.append(tdPrefix);
                    if (cell instanceof CellModel) {
                        boolean selectErrorCell = false;
                        if (cellUri != null) {
                            XlsUrlParser uriParser = new XlsUrlParser();
                            uriParser.parse(cellUri);
                            if (uriParser.range.equals(errorCell)) {
                                selectErrorCell = true;
                            }
                        }
                        ((CellModel)cell).atttributesToHtml(s, this.tableModel, selectErrorCell);
                    }
                    StringBuilder id = new StringBuilder();
                    id.append(prefix).append(String.valueOf(i + 1)).append(":").append(j + 1);
                    s.append(" id=\"").append((CharSequence)id).append("\">");
                    if (embedCellURI) {
                        s.append("<input name=\"uri\" type=\"hidden\" value=\"").append(cellUri).append("\"></input>");
                    }
                    if (cell.hasFormula()) {
                        s.append("<input name=\"formula\" type=\"hidden\" value=\"").append(cell.getFormula()).append("\"></input>");
                    }
                    if ((cellContent = cell.getContent(showFormulas)) != null) {
                        cellContent.replaceAll("", "");
                    }
                    s.append(cellContent).append("</td>\n");
                }
                s.append("</tr>\n");
            }
            s.append("</table>");
            return s.toString();
        }

        public String renderWithMenu(TableEditor editor, String menuId, String errorCell) {
            menuId = menuId == null ? "" : menuId;
            String eventHandlers = "onmousedown=\"openMenu('" + menuId + "',this,event)\"";
            if (editor.isEditable()) {
                eventHandlers = eventHandlers + " ondblclick=\"triggerEdit('" + menuId.replaceFirst("_menu", "") + "','" + WebUtil.internalPath("ajax/edit") + "', this)\"";
            }
            return this.render(eventHandlers, true, editor.isShowFormulas(), errorCell);
        }

        public void setCellIdPrefix(String prefix) {
            this.cellIdPrefix = prefix;
        }
    }
}

