/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.openl.rules.tableeditor.model.TableEditorModel;
import org.openl.rules.tableeditor.model.ui.ActionLink;
import org.openl.rules.tableeditor.renderkit.HTMLRenderer;
import org.openl.rules.tableeditor.renderkit.TableEditor;
import org.openl.rules.tableeditor.renderkit.TableViewerRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditorRenderer
extends TableViewerRenderer {
    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TableEditor tableEditor = new TableEditor(context, component);
        if (tableEditor.getTable() == null) {
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestParameterMap();
        String cellToEdit = (String)requestMap.get("cell");
        String errorCell = (String)requestMap.get("errorCell");
        List<ActionLink> actionLinks = this.getActionLinks(component);
        if (tableEditor.isEditable()) {
            this.initEditorModel(externalContext, tableEditor);
        }
        writer.write(new HTMLRenderer().render(tableEditor, false, cellToEdit, actionLinks, errorCell));
    }

    private List<ActionLink> getActionLinks(UIComponent component) {
        ArrayList<ActionLink> links = new ArrayList<ActionLink>();
        List children = component.getChildren();
        for (UIComponent child : children) {
            HtmlOutputLink link;
            boolean rendered;
            if (!(child instanceof HtmlOutputLink) || !(rendered = (link = (HtmlOutputLink)child).isRendered())) continue;
            List linkChildren = link.getChildren();
            String name = null;
            String action = null;
            Object value = link.getValue();
            if (value != null) {
                action = value.toString();
            }
            if (linkChildren != null && !linkChildren.isEmpty()) {
                Object linkChild = linkChildren.get(0);
                name = linkChild.toString();
            }
            if (name == null || name.equals("") || action == null || action.equals("")) continue;
            links.add(new ActionLink(name, action));
        }
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEditorModel(ExternalContext externalContext, TableEditor tableEditor) {
        Map sessionMap;
        Map map = sessionMap = externalContext.getSessionMap();
        synchronized (map) {
            TableEditorModel editorModel;
            HashMap<String, TableEditorModel> editorModelMap = (HashMap<String, TableEditorModel>)sessionMap.get("_tableEditorModel");
            if (editorModelMap == null) {
                editorModelMap = new HashMap<String, TableEditorModel>();
                sessionMap.put("_tableEditorModel", editorModelMap);
            }
            if ((editorModel = (TableEditorModel)editorModelMap.get(tableEditor.getId())) != null) {
                editorModel.cancel();
            }
            editorModel = new TableEditorModel(tableEditor);
            editorModel.setCollapseProps(tableEditor.isCollapseProps());
            editorModel.setBeforeSaveAction(tableEditor.getBeforeSaveAction());
            editorModel.setAfterSaveAction(tableEditor.getAfterSaveAction());
            editorModel.setSaveFailureAction(tableEditor.getSaveFailureAction());
            editorModelMap.put(tableEditor.getId(), editorModel);
        }
    }
}

