/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tableeditor.renderkit;

import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.table.constraints.Constraints;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.rules.table.xls.formatters.FormattersManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableProperty {
    private String name;
    private String displayName;
    private Object value;
    private Class<?> type;
    private String group;
    private String format;
    private Constraints constraints;
    private String description;
    private boolean system;
    private InheritanceLevel inheritanceLevel;

    private TableProperty(TablePropertyBuilder builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.value = builder.value;
        this.type = builder.type;
        this.group = builder.group;
        this.format = builder.format;
        this.constraints = builder.constraints;
        this.description = builder.description;
        this.system = builder.system;
        this.inheritanceLevel = builder.inheritanceLevel;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean canBeOverridenInTable() {
        boolean result = PropertiesChecker.isPropertySuitableForLevel((InheritanceLevel)InheritanceLevel.TABLE, (String)this.name);
        return result;
    }

    public boolean isModuleLevelProperty() {
        return InheritanceLevel.MODULE.equals((Object)this.inheritanceLevel);
    }

    public boolean isCategoryLevelProperty() {
        return InheritanceLevel.CATEGORY.equals((Object)this.inheritanceLevel);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Object getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return StringEscapeUtils.escapeHtml((String)this.getStringValue());
    }

    public void setStringValue(String value) {
        Object result = value;
        result = StringUtils.isNotEmpty((String)value) ? FormattersManager.getFormatter(this.type, (String)this.getFormat()).parse(value) : null;
        this.value = result;
    }

    public String getStringValue() {
        String result = "";
        if (this.value != null) {
            result = FormattersManager.getFormatter(this.type, (String)this.getFormat()).format(this.value);
        }
        return result;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            String valueStr = (String)value;
            value = StringUtils.isNotEmpty((String)valueStr) ? FormattersManager.getFormatter(this.type, (String)this.getFormat()).parse(valueStr) : null;
        }
        this.value = value;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isString() {
        return String.class.equals(this.type);
    }

    public boolean isDate() {
        return Date.class.equals(this.type);
    }

    public boolean isBoolean() {
        return Boolean.class.equals(this.type);
    }

    public boolean isDouble() {
        return Double.class.equals(this.type);
    }

    public boolean isEnum() {
        return this.type != null && this.type.isEnum();
    }

    public boolean isEnumArray() {
        return this.type != null && this.type.isArray() && this.type.getComponentType().isEnum();
    }

    public boolean isStringArray() {
        return this.type != null && this.type.isArray() && String.class.equals(this.type.getComponentType());
    }

    public void setConstraints(Constraints constraints) {
        this.constraints = constraints;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public boolean isSystem() {
        return this.system;
    }

    public InheritanceLevel getInheritanceLevel() {
        return this.inheritanceLevel;
    }

    public void setInheritanceLevel(InheritanceLevel inheritanceLevel) {
        this.inheritanceLevel = inheritanceLevel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TablePropertyBuilder {
        private String name;
        private Class<?> type;
        private String displayName;
        private Object value;
        private String group;
        private String format;
        private Constraints constraints;
        private String description;
        private boolean system;
        private InheritanceLevel inheritanceLevel;

        public TablePropertyBuilder(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public TablePropertyBuilder value(Object val) {
            this.value = val;
            return this;
        }

        public TablePropertyBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public TablePropertyBuilder group(String val) {
            this.group = val;
            return this;
        }

        public TablePropertyBuilder format(String val) {
            this.format = val;
            return this;
        }

        public TablePropertyBuilder constraints(Constraints val) {
            this.constraints = val;
            return this;
        }

        public TablePropertyBuilder description(String val) {
            this.description = val;
            return this;
        }

        public TablePropertyBuilder system(boolean val) {
            this.system = val;
            return this;
        }

        public TablePropertyBuilder inheritanceLevel(InheritanceLevel val) {
            this.inheritanceLevel = val;
            return this;
        }

        public TableProperty build() {
            return new TableProperty(this);
        }
    }
}

