/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository;

import org.openl.rules.repository.CommonVersion;

public class CommonVersionImpl
implements CommonVersion {
    private int major;
    private int minor;
    private int revision;
    private transient String versionName;

    public CommonVersionImpl(CommonVersion version) {
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.revision = version.getRevision();
    }

    public CommonVersionImpl(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public CommonVersionImpl(String s) {
        String[] version = s.split("\\.");
        if (version.length > 0) {
            this.major = Integer.parseInt(version[0], 10);
        }
        if (version.length > 1) {
            this.minor = Integer.parseInt(version[1], 10);
        }
        if (version.length > 2) {
            this.revision = Integer.parseInt(version[2], 10);
        }
    }

    public int compareTo(CommonVersion o) {
        if (this.major != o.getMajor()) {
            return this.major < o.getMajor() ? -1 : 1;
        }
        if (this.minor != o.getMinor()) {
            return this.minor < o.getMinor() ? -1 : 1;
        }
        if (this.revision != o.getRevision()) {
            return this.revision < o.getRevision() ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommonVersion)) {
            return false;
        }
        return this.compareTo((CommonVersion)o) == 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getVersionName() {
        if (this.versionName == null) {
            this.versionName = this.major + "." + this.minor + "." + this.revision;
        }
        return this.versionName;
    }

    public int hashCode() {
        return this.major << 22 ^ this.minor << 11 ^ this.revision;
    }
}

