/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.config.ConfigProperty;
import org.openl.config.ConfigPropertyString;
import org.openl.config.ConfigSet;
import org.openl.config.SysConfigManager;
import org.openl.rules.repository.RProductionRepository;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.exceptions.RRepositoryException;

public class ProductionRepositoryFactoryProxy {
    private static final Log log = LogFactory.getLog(ProductionRepositoryFactoryProxy.class);
    public static final String PROP_FILE = "rules-production.properties";
    private static final ConfigPropertyString confRepositoryFactoryClass = new ConfigPropertyString("repository.factory", null);
    private static RRepositoryFactory repFactory;

    public static synchronized RProductionRepository getRepositoryInstance() throws RRepositoryException {
        if (repFactory == null) {
            ProductionRepositoryFactoryProxy.initFactory();
        }
        return (RProductionRepository)repFactory.getRepositoryInstance();
    }

    private static synchronized void initFactory() throws RRepositoryException {
        ConfigSet confSet = SysConfigManager.getConfigManager().locate(PROP_FILE);
        confSet.updateProperty((ConfigProperty)confRepositoryFactoryClass);
        String className = (String)confRepositoryFactoryClass.getValue();
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            repFactory = (RRepositoryFactory)obj;
            repFactory.initialize(confSet);
        }
        catch (Exception e) {
            String msg = "Failed to initialize ProductionRepositoryFactory!";
            log.error((Object)msg, (Throwable)e);
            throw new RRepositoryException(msg, e);
        }
    }

    public static synchronized void release() throws RRepositoryException {
        if (repFactory != null) {
            repFactory.release();
            repFactory = null;
        }
    }

    public static synchronized void reset() throws RRepositoryException {
        ProductionRepositoryFactoryProxy.release();
        ProductionRepositoryFactoryProxy.initFactory();
    }
}

