/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.factories;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.openl.config.ConfigProperty;
import org.openl.config.ConfigPropertyString;
import org.openl.config.ConfigSet;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.factories.AbstractJcrRepositoryFactory;
import org.openl.rules.repository.factories.ShutDownHook;
import org.springframework.util.FileCopyUtils;

public class LocalJackrabbitRepositoryFactory
extends AbstractJcrRepositoryFactory {
    private static Log log = LogFactory.getLog(LocalJackrabbitRepositoryFactory.class);
    private final ConfigPropertyString confRepositoryHome = new ConfigPropertyString("repository.jackrabbit.local.home", "../local-repository");
    private final ConfigPropertyString confNodeTypeFile = new ConfigPropertyString("repository.jcr.nodetypes", "/org/openl/rules/repository/openl_nodetypes.xml");
    private final ConfigPropertyString confRepositoryName = new ConfigPropertyString("repository.name", "Local Jackrabbit");
    private TransientRepository repository;
    private String repHome;
    private String nodeTypeFile;
    private ShutDownHook shutDownHook;

    protected void finalize() {
        try {
            this.release();
        }
        catch (RRepositoryException e) {
            log.error((Object)"finalize", (Throwable)e);
        }
        if (this.shutDownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
        }
    }

    private void init() throws RepositoryException {
        try {
            String repConf = "/jackrabbit-repository.xml";
            URL url = ((Object)((Object)this)).getClass().getResource(repConf);
            File tempRepositorySettings = File.createTempFile("jackrabbit-repository", ".xml");
            tempRepositorySettings.deleteOnExit();
            String fullPath = tempRepositorySettings.getCanonicalPath();
            FileOutputStream tempRepositorySettingsStream = new FileOutputStream(tempRepositorySettings);
            FileCopyUtils.copy((InputStream)url.openStream(), (OutputStream)tempRepositorySettingsStream);
            ((OutputStream)tempRepositorySettingsStream).close();
            this.repository = new TransientRepository(fullPath, this.repHome);
            ShutDownHook shutDownHook = new ShutDownHook(this);
            Runtime.getRuntime().addShutdownHook(shutDownHook);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to init: " + e.getMessage(), (Throwable)e);
        }
    }

    public void initialize(ConfigSet confSet) throws RRepositoryException {
        super.initialize(confSet);
        confSet.updateProperty((ConfigProperty)this.confRepositoryHome);
        confSet.updateProperty((ConfigProperty)this.confNodeTypeFile);
        confSet.updateProperty((ConfigProperty)this.confRepositoryName);
        this.repHome = (String)this.confRepositoryHome.getValue();
        this.nodeTypeFile = (String)this.confNodeTypeFile.getValue();
        try {
            File f = new File(this.repHome);
            this.repHome = f.getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)("Failed to get canonical path for repository home (" + this.repHome + ")"), (Throwable)e);
        }
        try {
            this.init();
            this.setRepository((Repository)this.repository, (String)this.confRepositoryName.getValue());
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to initialize JCR: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initNodeTypes(NodeTypeManager ntm) throws RepositoryException {
        NodeTypeManagerImpl ntmi = (NodeTypeManagerImpl)ntm;
        try {
            InputStream is = null;
            try {
                is = ((Object)((Object)this)).getClass().getResourceAsStream(this.nodeTypeFile);
                ntmi.registerNodeTypes(is, "text/xml", true);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to init NodeTypes: " + e.getMessage(), (Throwable)e);
        }
    }

    public void release() throws RRepositoryException {
        if (this.repository != null) {
            this.repository.shutdown();
            this.repository = null;
        }
    }
}

