/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.factories;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.rmi.client.ClientRepositoryFactory;
import org.openl.config.ConfigProperty;
import org.openl.config.ConfigPropertyString;
import org.openl.config.ConfigSet;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.factories.AbstractJcrRepositoryFactory;

public class RmiJackrabbitRepositoryFactory
extends AbstractJcrRepositoryFactory {
    private final ConfigPropertyString confRmiUrl = new ConfigPropertyString("repository.jackrabbit.rmi.url", "//localhost:1099/jackrabbit.repository");

    public void initialize(ConfigSet confSet) throws RRepositoryException {
        super.initialize(confSet);
        confSet.updateProperty((ConfigProperty)this.confRmiUrl);
        ClientRepositoryFactory clientRepositoryFactory = new ClientRepositoryFactory();
        try {
            Repository repository;
            try {
                repository = clientRepositoryFactory.getRepository((String)this.confRmiUrl.getValue());
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
            this.setRepository(repository, "Jackrabbit RMI " + (String)this.confRmiUrl.getValue());
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to initialize JCR: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void initNodeTypes(NodeTypeManager ntm) throws RepositoryException {
        throw new RepositoryException("Cannot initialize node types via RMI.\nPlease, add OpenL node types definition manually or via command line tool.");
    }
}

