package org.openl.rules.repository;

import org.openl.rules.repository.RDeploymentDescriptorProject;
import org.openl.rules.repository.RRepository;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.exceptions.RRepositoryException;

import java.util.LinkedList;
import java.util.List;

/**
 * Stub to use when repository cannot be initialized.
 *
 * @author Aleh Bykhavets
 *
 */
public class NullRepository implements RRepository {
    private static final List<RProject> EMPTY_LIST = new LinkedList<RProject>();

    public RDeploymentDescriptorProject createDDProject(String name) throws RRepositoryException {
        fail();
        // will never reach
        return null;
    }

    public RProject createProject(String name) throws RRepositoryException {
        fail();
        // will never reach
        return null;
    }

    protected void fail() throws RRepositoryException {
        throw new RRepositoryException("Failed to initialize repository!", null);
    }

    public RDeploymentDescriptorProject getDDProject(String name) throws RRepositoryException {
        fail();
        // will never reach
        return null;
    }

    public List<RDeploymentDescriptorProject> getDDProjects() throws RRepositoryException {
        // empty list
        return new LinkedList<RDeploymentDescriptorProject>();
    }

    public String getName() {
        // TODO: may be put here something more consistent
        return "Failed to init Repository!";
    }

    public RProject getProject(String name) throws RRepositoryException {
        fail();
        // will never reach
        return null;
    }

    public List<RProject> getProjects() throws RRepositoryException {
        return EMPTY_LIST;
    }

    public List<RProject> getProjects4Deletion() throws RRepositoryException {
        return EMPTY_LIST;
    }

    public boolean hasDDProject(String name) throws RRepositoryException {
        return false;
    }

    public boolean hasProject(String name) throws RRepositoryException {
        return false;
    }

    public void release() {
        // Do nothing
    }
}
