package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.List;

import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetHeaderDefinition {

    private int row;
    private int column;

    private IOpenClass type;
    private List<SymbolicTypeDefinition> vars = new ArrayList<SymbolicTypeDefinition>();

    public SpreadsheetHeaderDefinition(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public int getRow() {
        return row;
    }

    public int getColumn() {
        return column;
    }
    
    public IOpenClass getType() {
        return type;
    }

    public List<SymbolicTypeDefinition> getVars() {
        return vars;
    }
    
    public void setType(IOpenClass type) {
        this.type = type;
    }

    public void addVarHeader(SymbolicTypeDefinition parsed) {
        vars.add(parsed);
    }

    public SymbolicTypeDefinition findVarDef(String name) {
        
        for (SymbolicTypeDefinition sdef : vars) {
            if (sdef.getName().getIdentifier().equals(name)) {
                return sdef;
            }
        }
        
        return null;
    }

    public Object getArray(SpreadsheetResultCalculator target, IRuntimeEnv env) {
        
        if (row < 0) {
            return target.getColumn(column, env);
        } else {
            return target.getRow(row, env);
        }
    }

    public String getFirstname() {
        
        for (SymbolicTypeDefinition definition : vars) {
            if (definition != null && definition.getName() != null) {
                return definition.getName().getIdentifier();
            }
        }

        return null;
    }


    public boolean isRow() {
        return row >= 0;
    }

    public String rowOrColumn() {
        return isRow() ? "row" : "column";
    }


}
