/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.eclipse.xls.launching;

import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.openl.eclipse.launch.ALaunchTarget;
import org.openl.eclipse.launch.ILaunchRequest;
import org.openl.eclipse.launch.OpenlLaunchTarget;

public class StudioLaunchTarget
extends ALaunchTarget {
    public static final String WORKSPACE_HOME_PROPERTY_NAME = "user.workspace.home";
    public static final String STUDIO_PROJECT_NAME = "org.openl.rules.webstudio";
    public static final String MAIN_CLASS_NAME = "org.openl.rules.webstudio.util.StartTomcat";
    public static final String VM_ARGS = "-Xms256M -Xmx1024M -XX:+UseParallelOldGC -XX:MaxPermSize=256M -XX:PermSize=128M -Duser.workspace.home=\"${workspace_loc}\" -Dorg.openl.rules.start.project=";
    private IResource resource;
    OpenlLaunchTarget module;

    public StudioLaunchTarget(IResource source) {
        this.resource = source;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StudioLaunchTarget)) {
            return false;
        }
        StudioLaunchTarget that = (StudioLaunchTarget)((Object)o);
        return this.resource.equals((Object)that.resource);
    }

    public String generateUniqueLaunchConfigurationName() {
        String prefix = "Open " + this.resource.getName() + " in WebStudio";
        return this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(prefix);
    }

    public String getDefaultLaunchConfigurationTypeID() {
        return IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public void initDefaultLaunchConfiguration(ILaunchConfigurationWorkingCopy wc, ILaunchRequest request) throws Exception {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, MAIN_CLASS_NAME);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.makeVMArgs());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, STUDIO_PROJECT_NAME);
    }

    public boolean isLaunchedBy(ILaunchConfiguration c) {
        try {
            String attrMain = c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            String attrProject = c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            String vmArgs = c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            return STUDIO_PROJECT_NAME.equals(attrProject) && MAIN_CLASS_NAME.equals(attrMain) && vmArgs.contains(this.makeVMArgs());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String makeVMArgs() {
        return VM_ARGS + this.resource.getName();
    }

    public String toString() {
        return "Launch " + this.resource.toString();
    }
}

