/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.eclipse.xls.launching;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.openl.main.SourceCodeURLTool;
import org.openl.rules.eclipse.ui.OpenlRulesPlugin;
import org.openl.rules.table.syntax.XlsURLConstants;
import org.openl.util.RuntimeExceptionWrapper;
import org.osgi.framework.Bundle;

public class XlsUrlParser
implements XlsURLConstants {
    public static final String FILE_PROTOCOL = "file:";
    public String scriptName;
    public String wbPath;
    public String wbName;
    public String wsName;
    public String range;

    static boolean endsWithSlash(String s) {
        return s.length() > 0 && XlsUrlParser.isSlash(s.charAt(s.length() - 1));
    }

    static boolean isSlash(char c) {
        return c == '/' || c == '\\';
    }

    URL guessFileURL(String url) {
        int idx = (url = this.ltrimFileURL(url)).indexOf(58);
        if (idx == 0 || idx > 1) {
            return null;
        }
        try {
            return new File(url).getCanonicalFile().toURL();
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    String ltrimFileURL(String url) {
        if ((url = url.replace('\\', '/')).startsWith(FILE_PROTOCOL)) {
            url = url.substring(FILE_PROTOCOL.length());
        }
        if (url.indexOf(47) == 0 && url.indexOf(58) == 2) {
            url = url.substring(1);
        }
        return url;
    }

    public void parse(String url) throws Exception {
        String SCRIPT_NAME = "LaunchExcel.vbs";
        this.scriptName = this.toCanonicalUrl(OpenlRulesPlugin.getDefault().getBundle(), SCRIPT_NAME);
        Map urlMap = SourceCodeURLTool.parseUrl((String)url);
        String file = (String)urlMap.get("file");
        this.wsName = (String)urlMap.get("sheet");
        this.range = (String)urlMap.get("range");
        if (this.range == null) {
            this.range = (String)urlMap.get("cell");
        }
        File f = new File(file).getCanonicalFile();
        this.wbPath = f.getParent();
        this.wbName = f.getName();
    }

    public String toCanonicalUrl(Bundle pd, String path) throws IOException {
        URL url = Platform.find((Bundle)pd, (IPath)new Path(path));
        if ((url = Platform.asLocalURL((URL)url)) == null) {
            return null;
        }
        String s = this.toCanonicalURL(url.toString());
        if (!XlsUrlParser.endsWithSlash(path) && XlsUrlParser.endsWithSlash(s)) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String toCanonicalURL(String path) {
        String url = this.toURL(path).toExternalForm();
        url = this.ltrimFileURL(url);
        return url;
    }

    public String toCanonicalURL(String parent, String child) {
        String url = this.toCanonicalURL(parent);
        if (child != null && child.length() > 0) {
            url = url + '/' + child;
        }
        return url;
    }

    public URL toURL(String path) {
        URL url = this.guessFileURL(path);
        if (url != null) {
            return url;
        }
        try {
            return new URL(path);
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    public URL[] toURL(String[] path) {
        URL[] urls = new URL[path.length];
        for (int i = 0; i < path.length; ++i) {
            urls[i] = this.toURL(path[i]);
        }
        return urls;
    }
}

