/*
 * Decompiled with CFR 0.152.
 */
package org.openl.config;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openl.config.ConfigProperty;
import org.openl.config.PassCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSet {
    public static String REPO_PASS_KEY = "repository.encode.decode.key";
    private final Logger log = LoggerFactory.getLogger(ConfigSet.class);
    private Map<String, Object> properties = new HashMap<String, Object>();

    public void addProperties(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String value = props.getProperty(key);
            this.addProperty(key, value);
        }
    }

    public void addProperties(Map<String, Object> props) {
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public void addProperty(String name, String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.properties.put(name, value);
    }

    public void updateProperties(Collection<ConfigProperty<?>> props) {
        for (ConfigProperty<?> prop : props) {
            this.updateProperty(prop);
        }
    }

    public void updateProperty(ConfigProperty<?> prop) {
        Object objectValue = this.properties.get(prop.getName());
        if (objectValue == null) {
            return;
        }
        try {
            prop.setTextValue(objectValue.toString());
        }
        catch (Exception e) {
            this.log.error("Failed to update ConfigProperty '{}' with value '{}'!", new Object[]{prop.getName(), objectValue, e});
        }
    }

    public void updatePasswordProperty(ConfigProperty<?> prop) {
        Object objectValue = this.properties.get(prop.getName());
        if (objectValue == null) {
            return;
        }
        String pass = objectValue.toString();
        String passKey = this.getPassKey();
        if (!StringUtils.isEmpty((CharSequence)passKey)) {
            try {
                prop.setTextValue(PassCoder.decode(pass, passKey));
            }
            catch (Exception e) {
                this.log.error("Failed to update ConfigProperty '{}' with value '{}'!", new Object[]{prop.getName(), objectValue, e});
            }
        } else {
            prop.setTextValue(pass);
        }
    }

    private String getPassKey() {
        if (this.properties.containsKey(REPO_PASS_KEY)) {
            if (this.properties.get(REPO_PASS_KEY) instanceof String[]) {
                String[] stringMass = (String[])this.properties.get(REPO_PASS_KEY);
                return stringMass[0];
            }
            return (String)this.properties.get(REPO_PASS_KEY);
        }
        return "";
    }
}

