/*
 * Decompiled with CFR 0.152.
 */
package org.openl.config;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.openl.config.ConfigSet;
import org.openl.config.PassCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private final Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private boolean useSystemProperties;
    private String propsLocation;
    private String defaultPropsLocation;
    private boolean autoSave;
    private Configuration systemConfiguration;
    private FileConfiguration configurationToSave;
    private FileConfiguration defaultConfiguration;
    private CompositeConfiguration compositeConfiguration;

    public ConfigurationManager(boolean useSystemProperties, String propsLocation) {
        this(useSystemProperties, propsLocation, null, false);
    }

    public ConfigurationManager(boolean useSystemProperties, String propsLocation, String defaultPropsLocation) {
        this(useSystemProperties, propsLocation, defaultPropsLocation, false);
    }

    public ConfigurationManager(boolean useSystemProperties, String propsLocation, String defaultPropsLocation, boolean autoSave) {
        this.useSystemProperties = useSystemProperties;
        this.propsLocation = propsLocation;
        this.defaultPropsLocation = defaultPropsLocation;
        this.autoSave = autoSave;
        this.init();
    }

    private void init() {
        this.compositeConfiguration = new CompositeConfiguration();
        this.compositeConfiguration.setDelimiterParsingDisabled(true);
        if (this.useSystemProperties) {
            SystemConfiguration configuration = new SystemConfiguration();
            configuration.setDelimiterParsingDisabled(true);
            this.systemConfiguration = configuration;
            this.compositeConfiguration.addConfiguration(this.systemConfiguration);
        }
        this.configurationToSave = this.createFileConfiguration(this.propsLocation, true);
        if (this.configurationToSave != null) {
            this.compositeConfiguration.addConfiguration((Configuration)this.configurationToSave);
            if (this.autoSave) {
                this.configurationToSave.setAutoSave(true);
            }
        }
        this.defaultConfiguration = this.createFileConfiguration(this.defaultPropsLocation);
        if (this.defaultConfiguration != null) {
            this.compositeConfiguration.addConfiguration((Configuration)this.defaultConfiguration);
        }
    }

    private FileConfiguration createFileConfiguration(String configLocation, boolean createIfNotExist) {
        PropertiesConfiguration configuration = null;
        if (configLocation != null) {
            try {
                if (createIfNotExist) {
                    configuration = new PropertiesConfiguration();
                    configuration.setDelimiterParsingDisabled(true);
                    File file = new File(configLocation);
                    configuration.setFile(file);
                    if (file.exists()) {
                        configuration.load();
                    }
                } else {
                    configuration = new PropertiesConfiguration();
                    configuration.setDelimiterParsingDisabled(true);
                    configuration.setFileName(configLocation);
                    configuration.load();
                }
            }
            catch (Exception e) {
                this.log.error("Error when initializing configuration: {}", (Object)configLocation, (Object)e);
            }
        }
        return configuration;
    }

    private FileConfiguration createFileConfiguration(String configLocation) {
        return this.createFileConfiguration(configLocation, false);
    }

    public String getStringProperty(String key) {
        return this.compositeConfiguration.getString(key);
    }

    public String[] getStringArrayProperty(String key) {
        return this.compositeConfiguration.getStringArray(key);
    }

    public boolean getBooleanProperty(String key) {
        return this.compositeConfiguration.getBoolean(key);
    }

    public int getIntegerProperty(String key) {
        return this.compositeConfiguration.getInt(key);
    }

    public Map<String, Object> getProperties() {
        return this.getProperties(false);
    }

    public Map<String, Object> getProperties(boolean cross) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Iterator iterator = this.compositeConfiguration.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (cross && this.configurationToSave.getProperty(key) == null) continue;
            Object value = this.compositeConfiguration.getProperty(key);
            if (value instanceof Collection || value != null && value.getClass().isArray()) {
                properties.put(key, this.getStringArrayProperty(key));
                continue;
            }
            properties.put(key, this.getStringProperty(key));
        }
        return properties;
    }

    public void setProperty(String key, Object value) {
        if (key != null && value != null) {
            if (!(value instanceof Collection) && !value.getClass().isArray()) {
                String defaultValue = this.compositeConfiguration.getString(key);
                if (defaultValue != null && !defaultValue.equals(value.toString())) {
                    this.getConfigurationToSave().setProperty(key, (Object)value.toString());
                }
            } else {
                String[] defaultValue = this.compositeConfiguration.getStringArray(key);
                if (defaultValue != null) {
                    if (value instanceof Collection) {
                        Collection v = (Collection)value;
                        value = v.toArray(new String[v.size()]);
                    }
                    if (!defaultValue.equals(value)) {
                        this.getConfigurationToSave().setProperty(key, (Object)value);
                    }
                }
            }
        } else if (key != null) {
            this.removeProperty(key);
        }
    }

    public String getPath(String key) {
        return ConfigurationManager.normalizePath(this.getStringProperty(key));
    }

    public void setPath(String key, String path) {
        String defaultPath = ConfigurationManager.normalizePath(this.compositeConfiguration.getString(key));
        String newPath = ConfigurationManager.normalizePath(path);
        if (defaultPath != null && !defaultPath.equals(newPath)) {
            this.getConfigurationToSave().setProperty(key, (Object)newPath);
        }
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        File pathFile = new File(path);
        if (!(pathFile.isAbsolute() || path.startsWith("/") || path.startsWith("\\"))) {
            pathFile = new File(File.separator + path);
        }
        return pathFile.getAbsolutePath();
    }

    public void removeProperty(String key) {
        this.getConfigurationToSave().clearProperty(key);
    }

    private FileConfiguration getConfigurationToSave() {
        if (this.configurationToSave == null) {
            this.configurationToSave = this.createFileConfiguration(this.propsLocation, true);
        }
        return this.configurationToSave;
    }

    public boolean isSystemProperty(String name) {
        return this.systemConfiguration != null && this.systemConfiguration.getString(name) != null;
    }

    public boolean save() {
        if (this.configurationToSave != null) {
            try {
                this.configurationToSave.save();
                return true;
            }
            catch (Exception e) {
                this.log.error("Error when saving configuration: {}", (Object)this.configurationToSave.getBasePath(), (Object)e);
            }
        }
        return false;
    }

    public boolean restoreDefaults() {
        if (this.configurationToSave != null && !this.configurationToSave.isEmpty()) {
            this.configurationToSave.clear();
            return this.save();
        }
        return false;
    }

    public boolean delete() {
        boolean deleted = false;
        if (this.configurationToSave != null) {
            deleted = this.configurationToSave.getFile().delete();
            this.configurationToSave = null;
        }
        return deleted;
    }

    public void setPassword(String key, String pass) {
        try {
            String repoPassKey = this.getRepoPassKey();
            this.setProperty(key, StringUtils.isEmpty((CharSequence)repoPassKey) ? pass : PassCoder.encode(pass, repoPassKey));
        }
        catch (Exception e) {
            this.log.error("Error when setting password property: {}", (Object)key, (Object)e);
        }
    }

    public String getPassword(String key) {
        try {
            String repoPassKey = this.getRepoPassKey();
            String pass = this.getStringProperty(key);
            return StringUtils.isEmpty((CharSequence)repoPassKey) ? pass : PassCoder.decode(pass, repoPassKey);
        }
        catch (Exception e) {
            this.log.error("Error when getting password property: {}", (Object)key, (Object)e);
            return "";
        }
    }

    public String getRepoPassKey() {
        return this.compositeConfiguration.containsKey(ConfigSet.REPO_PASS_KEY) ? this.compositeConfiguration.getString(ConfigSet.REPO_PASS_KEY) : "";
    }
}

