/*
 * Decompiled with CFR 0.152.
 */
package org.openl.config;

import org.apache.commons.lang3.StringUtils;
import org.openl.config.ConfigurationManager;

public class ConfigurationManagerFactory {
    private boolean useSystemProperties;
    private String defaultPropertiesLocation;
    private String propertiesFolder;

    public ConfigurationManagerFactory(boolean useSystemProperties, String defaultPropertiesLocation, String propertiesFolder) {
        this.useSystemProperties = useSystemProperties;
        this.defaultPropertiesLocation = StringUtils.trimToNull((String)defaultPropertiesLocation);
        if (!(StringUtils.isBlank((CharSequence)propertiesFolder) || propertiesFolder.endsWith("/") || propertiesFolder.endsWith("\\"))) {
            propertiesFolder = propertiesFolder + "/";
        }
        this.propertiesFolder = StringUtils.trimToEmpty((String)propertiesFolder);
    }

    public ConfigurationManager getConfigurationManager(String propertiesName) {
        String fullPath = this.propertiesFolder + propertiesName;
        String defaultFile = this.defaultPropertiesLocation != null ? this.defaultPropertiesLocation : fullPath;
        return new ConfigurationManager(this.useSystemProperties, StringUtils.trimToNull((String)fullPath), StringUtils.trimToNull((String)defaultFile));
    }
}

