/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import java.util.BitSet;
import java.util.Iterator;
import org.openl.domain.BitSetIterator;
import org.openl.domain.Enum;
import org.openl.domain.FixedSizeDomain;
import org.openl.domain.IType;
import org.openl.util.AOpenIterator;

public class EnumDomain<T>
extends FixedSizeDomain<T> {
    private BitSet bits;
    private Enum<T> enumeration;

    public EnumDomain(Enum<T> enumeration, BitSet bits) {
        this.bits = bits;
        this.enumeration = enumeration;
    }

    public EnumDomain(Enum<T> enumeration, T[] objs) {
        this.bits = new BitSet(enumeration.size());
        this.enumeration = enumeration;
        for (int i = 0; i < objs.length; ++i) {
            int idx = enumeration.getIndex(objs[i]);
            this.bits.set(idx);
        }
    }

    public EnumDomain(T[] elements) {
        this(new Enum<T>(elements), elements);
    }

    public EnumDomain<T> and(EnumDomain<T> sd) {
        this.checkOperand(sd);
        if (this.bits.equals(sd.bits)) {
            return this;
        }
        BitSet copy = (BitSet)this.bits.clone();
        copy.and(sd.bits);
        return new EnumDomain<T>(this.enumeration, copy);
    }

    void checkOperand(EnumDomain<T> sd) {
        if (sd.getEnum() != this.enumeration) {
            throw new RuntimeException("Can not use subsets of different domains");
        }
    }

    public boolean contains(T obj) {
        try {
            int idx = this.enumeration.getIndex(obj);
            return this.bits.get(idx);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EnumDomain)) {
            return false;
        }
        EnumDomain ed = (EnumDomain)obj;
        return this.enumeration.equals(ed.enumeration) && this.bits.equals(ed.bits);
    }

    @Override
    public IType getElementType() {
        return null;
    }

    public Enum<T> getEnum() {
        return this.enumeration;
    }

    public int hashCode() {
        return this.enumeration.hashCode() * 37 + this.bits.hashCode();
    }

    @Override
    public Iterator<T> iterator() {
        return new EnumDomainIterator();
    }

    public EnumDomain<T> not() {
        int size = this.enumeration.size();
        BitSet bs = (BitSet)this.bits.clone();
        bs.flip(0, size);
        return new EnumDomain<T>(this.enumeration, bs);
    }

    public EnumDomain<T> or(EnumDomain<T> sd) {
        this.checkOperand(sd);
        if (this.bits.equals(sd.bits)) {
            return this;
        }
        BitSet copy = (BitSet)this.bits.clone();
        copy.or(sd.bits);
        return new EnumDomain<T>(this.enumeration, copy);
    }

    @Override
    public boolean selectObject(T obj) {
        return this.contains(obj);
    }

    @Override
    public boolean selectType(IType type) {
        return false;
    }

    @Override
    public int size() {
        return this.bits.cardinality();
    }

    public EnumDomain<T> sub(EnumDomain<T> sd) {
        this.checkOperand(sd);
        if (this.bits.equals(sd.bits)) {
            return this;
        }
        BitSet copy = (BitSet)this.bits.clone();
        copy.andNot(sd.bits);
        return new EnumDomain<T>(this.enumeration, copy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean f = false;
        for (T o : this.enumeration.getAllObjects()) {
            if (f) {
                sb.append(",");
            } else {
                f = true;
            }
            sb.append(o.toString());
        }
        return "[" + sb.toString() + "]";
    }

    class EnumDomainIterator
    extends AOpenIterator<T> {
        private BitSetIterator bsi;

        EnumDomainIterator() {
            this.bsi = new BitSetIterator(EnumDomain.this.bits);
        }

        @Override
        public boolean hasNext() {
            return this.bsi.hasNext();
        }

        @Override
        public T next() {
            int idx = this.bsi.nextInt();
            return ((EnumDomain)EnumDomain.this).enumeration.allObjects[idx];
        }
    }
}

