/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import org.openl.domain.AIntIterator;
import org.openl.domain.IIntIterator;

public interface IIntSelector {
    public boolean select(int var1);

    public static final class IntSelectIterator
    extends AIntIterator {
        IIntSelector selector;
        IIntIterator it;
        int next;
        boolean hasNext = false;

        IntSelectIterator(IIntIterator it, IIntSelector selector) {
            this.it = it;
            this.selector = selector;
        }

        void findNext() {
            while (this.it.hasNext()) {
                int x = this.it.nextInt();
                if (!this.selector.select(x)) continue;
                this.next = x;
                this.hasNext = true;
                return;
            }
            this.next = -1;
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNext) {
                this.findNext();
            }
            return this.hasNext;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            this.hasNext = false;
            return this.next;
        }

        @Override
        public boolean isResetable() {
            return this.it.isResetable();
        }

        @Override
        public void reset() {
            this.hasNext = false;
            this.it.reset();
        }
    }
}

