/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import java.util.BitSet;
import org.openl.domain.BitSetIterator;
import org.openl.domain.IIntDomain;
import org.openl.domain.IIntIterator;

public class IntSet
implements IIntDomain {
    int min;
    int max;
    BitSet bits;

    public IntSet(int min, int max) {
        this.min = min;
        this.max = max;
        this.bits = new BitSet(max - min + 1);
    }

    public void add(int bit) {
        this.bits.set(bit - this.min);
    }

    @Override
    public boolean contains(int value) {
        return this.bits.get(value - this.min);
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public IIntIterator intIterator() {
        return new BitSetIterator(this.bits, this.min);
    }

    public void remove(int bit) {
        this.bits.clear(bit - this.min);
    }

    @Override
    public int size() {
        return this.bits.cardinality();
    }
}

