/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openl.util.Appender;
import org.openl.util.IAppender;
import org.openl.util.IBlock;
import org.openl.util.IConvertor;
import org.openl.util.IOpenIterator;
import org.openl.util.IOpenIteratorExtender;
import org.openl.util.ISelector;

public abstract class AOpenIterator<T>
implements IOpenIterator<T> {
    public static final EmptyIterator<?> EMPTY = new EmptyIterator();

    public static <T> List<T> asList(Iterator<T> it) {
        int size = AOpenIterator.size(it);
        ArrayList<T> result = null;
        switch (size) {
            case 0: {
                return Collections.emptyList();
            }
            case -1: {
                result = new ArrayList<T>();
                break;
            }
            default: {
                result = new ArrayList(size);
            }
        }
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> IOpenIterator<T> asOpenIterator(Iterator<T> it) {
        if (it == null) {
            return AOpenIterator.empty();
        }
        if (it instanceof IOpenIterator) {
            return (IOpenIterator)it;
        }
        return new SimpleIteratorWrapper<T>(it);
    }

    public static <T> Set<T> asSet(Iterator<T> it) {
        int size = AOpenIterator.size(it);
        HashSet<T> result = null;
        switch (size) {
            case 0: {
                return Collections.emptySet();
            }
            case -1: {
                result = new HashSet<T>();
                break;
            }
            default: {
                result = new HashSet(size);
            }
        }
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T, C> IOpenIterator<C> collect(Iterator<T> it, IConvertor<T, C> ic) {
        return new CollectIterator<T, C>(it, ic);
    }

    public static <T> IOpenIterator<T> empty() {
        return EMPTY;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY;
    }

    public static <X> void evaluate(IBlock block, Iterator<X> it) {
        while (it.hasNext()) {
            block.evaluate(it.next());
        }
    }

    public static <E, T> IOpenIterator<E> extend(Iterator<T> it, IOpenIteratorExtender<E, T> mod) {
        return new ModifierIterator<E, T>(it, mod);
    }

    public static boolean isEmpty(Iterator<?> it) {
        return it == null || it == EMPTY;
    }

    public static <T> IOpenIterator<T> merge(IOpenIterator<T> it1, IOpenIterator<T> it2) {
        if (AOpenIterator.isEmpty(it1)) {
            if (it2 == null) {
                return AOpenIterator.empty();
            }
            return it2;
        }
        if (AOpenIterator.isEmpty(it2)) {
            return it1;
        }
        return new MergeIterator<T>(it1, it2);
    }

    public static <T> Iterator<T> merge(Iterator<T> it1, Iterator<T> it2) {
        if (AOpenIterator.isEmpty(it1)) {
            if (it2 == null) {
                return AOpenIterator.emptyIterator();
            }
            return it2;
        }
        if (AOpenIterator.isEmpty(it2)) {
            return it1;
        }
        return new MergeIterator<T>(it1, it2);
    }

    public static <X> IOpenIterator<X> reverse(Iterator<X> it) {
        if (it instanceof IOpenIterator) {
            return ((IOpenIterator)it).reverse();
        }
        throw new UnsupportedOperationException();
    }

    public static <X> IOpenIterator<X> select(Iterator<X> it, ISelector<X> is) {
        return new SelectIterator<X>(it, is);
    }

    public static <T> IOpenIterator<T> single(T value) {
        if (value == null) {
            return AOpenIterator.empty();
        }
        return new SingleIterator<T>(value);
    }

    public static <T> int size(Iterator<T> it) {
        if (it instanceof IOpenIterator) {
            return ((IOpenIterator)it).size();
        }
        return -1;
    }

    public static <T> Iterator<T> sort(Iterator<T> it, Comparator<T> cmp) {
        int size = AOpenIterator.size(it);
        switch (size) {
            case 0: {
                return AOpenIterator.empty();
            }
            case 1: {
                return it;
            }
        }
        ArrayList v = new ArrayList();
        AOpenIterator.store(it, Appender.toCollection(v));
        Collections.sort(v, cmp);
        return v.iterator();
    }

    public static <T> int store(Iterator<T> it, IAppender<T> appender) {
        int cnt = 0;
        while (it.hasNext() && appender.add(it.next())) {
            ++cnt;
        }
        return cnt;
    }

    @Override
    public IOpenIterator<T> append(IOpenIterator<T> it) {
        return it == null || it == EMPTY ? this : AOpenIterator.merge(this, it);
    }

    @Override
    public Iterator<T> append(Iterator<T> it) {
        return it == null || it == EMPTY ? this : AOpenIterator.merge(this, it);
    }

    @Override
    public List<T> asList() {
        return AOpenIterator.asList(this);
    }

    @Override
    public Set<T> asSet() {
        return AOpenIterator.asSet(this);
    }

    @Override
    public <C> IOpenIterator<C> collect(IConvertor<T, C> ic) {
        return new CollectIterator<T, C>(this, ic);
    }

    @Override
    public <C> IOpenIterator<C> convert(IConvertor<T, C> ic) {
        return this.collect(ic);
    }

    @Override
    public int count() {
        int cnt = 0;
        while (this.hasNext()) {
            this.next();
            ++cnt;
        }
        return cnt;
    }

    @Override
    public void evaluate(IBlock block) {
        AOpenIterator.evaluate(block, this);
    }

    @Override
    public <E> IOpenIterator<E> extend(IOpenIteratorExtender<E, T> mod) {
        return AOpenIterator.extend(this, mod);
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }

    @Override
    public IOpenIterator<T> reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IOpenIterator<T> select(ISelector<T> is) {
        return new SelectIterator<T>(this, is);
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public int skip(int n) {
        int x = n;
        while (n > 0 && this.hasNext()) {
            this.next();
            --n;
        }
        return x - n;
    }

    @Override
    public IOpenIterator<T> sort(Comparator<T> cmp) {
        return AOpenIterator.asOpenIterator(AOpenIterator.sort(this, cmp));
    }

    public int store(IAppender<T> appender) {
        return AOpenIterator.store(this, appender);
    }

    static final class SingleIterator<T>
    extends AOpenIterator<T> {
        T value;

        SingleIterator(T value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.value != null;
        }

        @Override
        public T next() {
            if (this.value == null) {
                throw new NoSuchElementException();
            }
            T tmp = this.value;
            this.value = null;
            return tmp;
        }

        @Override
        public IOpenIterator<T> reverse() {
            if (this.size() == 0) {
                return SingleIterator.empty();
            }
            return this;
        }

        @Override
        public final int size() {
            return this.value == null ? 0 : 1;
        }
    }

    static class SimpleIteratorWrapper<T>
    extends IteratorWrapper<T, T> {
        SimpleIteratorWrapper(Iterator<T> it) {
            super(it);
        }

        @Override
        public T next() {
            return (T)this.it.next();
        }
    }

    static final class SelectIterator<T>
    extends IteratorWrapper<T, T> {
        ISelector<T> selector;
        T next;
        boolean hasNext = false;

        SelectIterator(Iterator<T> it, ISelector<T> selector) {
            super(it);
            this.selector = selector;
        }

        void findNext() {
            while (this.it.hasNext()) {
                Object obj = this.it.next();
                if (!this.selector.select(obj)) continue;
                this.next = obj;
                this.hasNext = true;
                return;
            }
            this.next = null;
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNext) {
                this.findNext();
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            this.hasNext = false;
            return this.next;
        }
    }

    static class ModifierIterator<E, T>
    extends AOpenIterator<E> {
        Iterator<T> baseIterator;
        IOpenIteratorExtender<E, T> modifier;
        boolean hasNext = false;
        E next = null;
        Iterator<E> modifierIterator;

        ModifierIterator(Iterator<T> baseIterator, IOpenIteratorExtender<E, T> modifier) {
            this.baseIterator = baseIterator;
            this.modifier = modifier;
        }

        protected void findNextObject() {
            while (this.modifierIterator == null || !this.modifierIterator.hasNext()) {
                if (this.modifierIterator == null) {
                    this.modifierIterator = this.getNextIterator();
                    if (this.modifierIterator == null) {
                        return;
                    }
                }
                if (this.modifierIterator.hasNext()) continue;
                this.modifierIterator = null;
            }
            this.next = this.modifierIterator.next();
            this.hasNext = true;
        }

        protected Iterator<E> getNextIterator() {
            while (this.baseIterator.hasNext()) {
                Iterator<E> it = this.modifier.extend(this.baseIterator.next());
                if (it == null) continue;
                return it;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            this.findNextObject();
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            this.hasNext = false;
            return this.next;
        }
    }

    public static class MergeIterator<T>
    extends AOpenIterator<T> {
        Iterator<T>[] itt;
        int current = 0;

        public MergeIterator(Iterator<T> it1, Iterator<T> it2) {
            this.itt = (Iterator[])Array.newInstance(Iterator.class, 2);
            this.itt[0] = it1;
            this.itt[1] = it2;
        }

        public MergeIterator(Iterator<T>[] itt) {
            this.itt = itt;
        }

        @Override
        public boolean hasNext() {
            while (this.current < this.itt.length) {
                if (this.itt[this.current].hasNext()) {
                    return true;
                }
                ++this.current;
            }
            return false;
        }

        @Override
        public T next() {
            return this.itt[this.current].next();
        }

        @Override
        public void remove() {
            this.itt[this.current].remove();
        }

        @Override
        public int size() {
            int total = 0;
            for (int i = this.current; i < this.itt.length; ++i) {
                int size = MergeIterator.size(this.itt[i]);
                if (size == -1) {
                    return -1;
                }
                total += size;
            }
            return total;
        }
    }

    static abstract class IteratorWrapper<T, C>
    extends AOpenIterator<C> {
        protected Iterator<T> it;

        IteratorWrapper(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public abstract C next();
    }

    static final class EmptyIterator<T>
    extends AOpenIterator<T> {
        EmptyIterator() {
        }

        @Override
        public <C> IOpenIterator<C> collect(IConvertor<T, C> ic) {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException("EmptyIterator");
        }

        @Override
        public IOpenIterator<T> reverse() {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class CollectIterator<T, C>
    extends IteratorWrapper<T, C> {
        IConvertor<T, C> collector;

        CollectIterator(Iterator<T> it, IConvertor<T, C> convertor) {
            super(it);
            this.collector = convertor;
        }

        @Override
        public C next() {
            return this.collector.convert(this.it.next());
        }
    }
}

