/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import org.openl.util.ArrayTool;

public class BooleanUtils {
    public static final String NULL_ARRAY_MSG = "The Array must not be null";
    public static final String EMPTY_ARRAY_MSG = "Array is empty";
    public static final String NULL_VALUE_IN_ARRAY_MSG = "Array shouldn`t contain null objects";

    public static boolean toBoolean(Object value) {
        Boolean bValue = BooleanUtils.toBooleanObject(value);
        if (bValue == null) {
            return false;
        }
        return bValue;
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        return BooleanUtils.toBooleanObject(value, defaultValue);
    }

    public static Boolean toBooleanObject(Object value) {
        Boolean bValue = null;
        if (value instanceof String) {
            bValue = org.apache.commons.lang3.BooleanUtils.toBooleanObject((String)((String)value));
        } else if (value instanceof Integer) {
            bValue = org.apache.commons.lang3.BooleanUtils.toBoolean((int)((Integer)value));
        } else if (value instanceof Boolean) {
            bValue = (Boolean)value;
        }
        return bValue;
    }

    public static Boolean toBooleanObject(Object value, Boolean defaultValue) {
        Boolean bValue = BooleanUtils.toBooleanObject(value);
        return bValue == null ? defaultValue : bValue;
    }

    public static boolean and(boolean[] values) {
        if (values == null) {
            return false;
        }
        for (boolean value : values) {
            if (value) continue;
            return false;
        }
        return true;
    }

    public static boolean and(Boolean[] values) {
        if (values == null) {
            return false;
        }
        if (ArrayTool.contains(values, null)) {
            return false;
        }
        for (Boolean value : values) {
            if (value.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean xor(boolean[] values) {
        BooleanUtils.checkOnEmptyArray(values);
        boolean result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result ^= values[i];
        }
        return result;
    }

    public static boolean xor(Boolean[] values) {
        BooleanUtils.checkOnEmptyArray(values);
        Boolean result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result ^ values[i];
        }
        return result;
    }

    public static boolean or(boolean[] values) {
        BooleanUtils.checkOnEmptyArray(values);
        boolean result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result || values[i];
        }
        return result;
    }

    public static boolean or(Boolean[] values) {
        BooleanUtils.checkOnEmptyArray(values);
        Boolean result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result != false || values[i] != false;
        }
        return result;
    }

    private static void checkOnEmptyArray(Boolean[] values) {
        if (values == null) {
            throw new IllegalArgumentException(NULL_ARRAY_MSG);
        }
        if (values.length == 0) {
            throw new IllegalArgumentException(EMPTY_ARRAY_MSG);
        }
        if (ArrayTool.contains(values, null)) {
            throw new IllegalArgumentException(NULL_VALUE_IN_ARRAY_MSG);
        }
    }

    private static void checkOnEmptyArray(boolean[] values) {
        if (values == null) {
            throw new IllegalArgumentException(NULL_ARRAY_MSG);
        }
        if (values.length == 0) {
            throw new IllegalArgumentException(EMPTY_ARRAY_MSG);
        }
    }
}

