/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.openl.util.DateDifference;

public class DateTool {
    public static final int MONTHS_IN_YEAR = 12;
    public static final int QUARTERS_IN_YEAR = 4;
    public static final int MONTHS_IN_QUARTER = 3;
    public static final int SECONDS_IN_DAY = 86400;
    public static final int MILLISECONDS_IN_DAY = 86400000;

    public static int absMonth(Date d) {
        return DateTool.year(d) * 12 + DateTool.month(d);
    }

    public static int absQuarter(Date d) {
        return DateTool.year(d) * 4 + DateTool.quarter(d);
    }

    public static int dayDiff(Date endDate, Date startDate) {
        return DateDifference.getDifferenceInDays(endDate, startDate);
    }

    public static int dayOfWeek(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(7);
    }

    public static int dayOfMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(5);
    }

    public static int dayOfYear(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(6);
    }

    public static int weekOfMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(4);
    }

    public static int weekOfYear(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(3);
    }

    public static Date firstDateOfQuarter(int absQuarter) {
        Calendar c = Calendar.getInstance();
        c.set(14, 0);
        c.set(absQuarter / 4, absQuarter % 4 * 3, 1, 0, 0, 0);
        return c.getTime();
    }

    public static Date lastDateOfQuarter(int absQuarter) {
        Calendar c = Calendar.getInstance();
        c.set(14, 0);
        c.set(absQuarter / 4, absQuarter % 4 * 3 + 2, 1, 0, 0, 0);
        int lastDay = DateTool.lastDayOfMonth(c.getTime());
        c.set(5, lastDay);
        return c.getTime();
    }

    public static int lastDayOfMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.getActualMaximum(5);
    }

    public static int monthDiff(Date endDate, Date startDate) {
        return DateDifference.getDifferenceInMonths(endDate, startDate);
    }

    public static int yearDiff(Date endDate, Date startDate) {
        return DateDifference.getDifferenceInYears(endDate, startDate);
    }

    public static int weekDiff(Date endDate, Date startDate) {
        return DateDifference.getDifferenceInWeeks(endDate, startDate);
    }

    public static int quarter(Date d) {
        return DateTool.month(d) / 3;
    }

    public static int second(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(13);
    }

    public static int minute(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(12);
    }

    public static int hour(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(10);
    }

    public static int hourOfDay(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(11);
    }

    public static int month(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(2);
    }

    public static int year(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(1);
    }

    public static String amPm(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        if (c.get(9) == 0) {
            return "AM";
        }
        return "PM";
    }

    public static String dateToString(Date date, String dateFormat) throws Exception {
        DateFormat df = null;
        String stringDate = "";
        String datePattern = "([A-Za-z]{1,}(.|/|-| )){1,}";
        DateFormat dateFormat2 = df = dateFormat == null ? DateFormat.getDateInstance(3) : new SimpleDateFormat(dateFormat);
        if (dateFormat == null) {
            stringDate = df.format(date);
        } else if (dateFormat.matches(datePattern)) {
            stringDate = df.format(date);
        }
        return stringDate;
    }

    public static String dateToString(Date date) throws Exception {
        return DateTool.dateToString(date, null);
    }
}

