/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.openl.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileTool {
    public static File buildRelativePath(File startDir, File targetFile) throws IOException {
        int i;
        if (startDir == null) {
            return targetFile.isFile() ? targetFile.getParentFile() : targetFile;
        }
        if (startDir.equals(targetFile)) {
            return new File(".");
        }
        File[] pfDir = FileTool.parents(startDir);
        File[] pfTarget = FileTool.parents(targetFile);
        int size = Math.min(pfDir.length, pfTarget.length);
        int lastEqual = -1;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!pfDir[i2].equals(pfTarget[i2])) continue;
            lastEqual = i2;
        }
        if (lastEqual == -1) {
            return targetFile.getAbsoluteFile();
        }
        int stepsToCommonParent = pfDir.length - 1 - lastEqual;
        String path = ".";
        for (i = 0; i < stepsToCommonParent; ++i) {
            path = i == 0 ? ".." : path + "/..";
        }
        stepsToCommonParent = pfTarget.length - 1 - lastEqual;
        for (i = 0; i < stepsToCommonParent; ++i) {
            path = path + "/" + pfTarget[lastEqual + i + 1].getName();
        }
        return new File(path);
    }

    static File[] parents(File f) throws IOException {
        f = f.getCanonicalFile();
        ArrayList<File> v = new ArrayList<File>();
        v.add(f);
        while ((f = f.getParentFile()) != null) {
            v.add(f.getCanonicalFile());
        }
        int size = v.size();
        File[] ff = new File[size];
        for (int i = 0; i < size; ++i) {
            ff[i] = (File)v.get(size - 1 - i);
        }
        return ff;
    }

    public static File toTempFile(InputStream source, String fileName) {
        File file = null;
        try {
            file = File.createTempFile(fileName, null);
            IOUtils.copyAndClose(source, new FileOutputStream(file));
        }
        catch (IOException e) {
            Logger log = LoggerFactory.getLogger(FileTool.class);
            log.error("Error when creating file: {}", (Object)fileName, (Object)e);
        }
        return file;
    }
}

