/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import org.openl.util.IOUtils;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 0x800000;

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("openl", ".tmp");
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static void copy(File src, File dest) throws IOException {
        String destPath;
        if (!src.exists()) {
            throw new FileNotFoundException("Source '" + src + "' does not exist");
        }
        String srcPath = src.getCanonicalPath();
        if (srcPath.equals(destPath = dest.getCanonicalPath())) {
            throw new IOException("Source '" + src + "' and destination '" + dest + "' are the same");
        }
        if (src.isDirectory()) {
            Collection<String> looped = FileUtils.getLoopedDirectories(src, dest);
            FileUtils.doCopyDirectory(src, dest, looped);
        } else {
            if (destPath.startsWith(srcPath)) {
                throw new IOException("Destination '" + dest + "' has the same path of the source '" + src + "'");
            }
            File destFile = dest;
            if (dest.isDirectory()) {
                destFile = new File(dest, src.getName());
            } else {
                File parentFile = dest.getParentFile();
                if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
                    throw new IOException("Destination '" + parentFile + "' directory cannot be created");
                }
            }
            FileUtils.doCopyFile(src, destFile);
        }
    }

    private static Collection<String> getLoopedDirectories(File src, File dest) throws IOException {
        if (!dest.getCanonicalPath().startsWith(src.getCanonicalPath())) {
            return null;
        }
        ArrayList<String> looped = null;
        File[] srcFiles = src.listFiles();
        if (srcFiles != null && srcFiles.length > 0) {
            looped = new ArrayList<String>(srcFiles.length + 1);
            for (File srcFile : srcFiles) {
                File copiedFile = new File(dest, srcFile.getName());
                if (!srcFile.isDirectory()) continue;
                looped.add(copiedFile.getCanonicalPath());
            }
            if (!dest.exists()) {
                looped.add(dest.getCanonicalPath());
            }
        }
        return looped;
    }

    private static void doCopyDirectory(File srcDir, File destDir, Collection<String> excluded) throws IOException {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (excluded != null && excluded.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                FileUtils.doCopyDirectory(srcFile, dstFile, excluded);
                continue;
            }
            FileUtils.doCopyFile(srcFile, dstFile);
        }
        destDir.setLastModified(srcDir.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, 0x800000L)) {
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(output);
        IOUtils.closeQuietly(fos);
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(fis);
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        destFile.setLastModified(srcFile.lastModified());
    }

    public static void move(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("Source '" + src + "' does not exist");
        }
        if (dest.exists()) {
            throw new IOException("Destination '" + dest + "' already exists");
        }
        boolean rename = src.renameTo(dest);
        if (!rename) {
            if (src.isDirectory() && dest.getCanonicalPath().startsWith(src.getCanonicalPath())) {
                throw new IOException("Cannot move directory: " + src + " to a subdirectory of itself: " + dest);
            }
            FileUtils.copy(src, dest);
            FileUtils.delete(src);
            if (src.exists()) {
                throw new IOException("Failed to delete original directory or file '" + src + "' after copy to '" + dest + "'");
            }
        }
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException("Failed to list contents of direcory: " + file);
            }
            IOException exception = null;
            for (File fl : files) {
                try {
                    FileUtils.delete(fl);
                }
                catch (IOException ioe) {
                    exception = ioe;
                }
            }
            if (null != exception) {
                throw exception;
            }
            if (!file.delete()) {
                throw new IOException("Unable to delete directory: " + file);
            }
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                throw new IOException("Unable to delete file: " + file);
            }
        }
    }

    public static void deleteQuietly(File file) {
        try {
            FileUtils.delete(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int sep = FileUtils.getSeparatorIndex(filename);
        return filename.substring(sep + 1);
    }

    public static String getBaseName(String filename) {
        int sep;
        if (filename == null) {
            return null;
        }
        int dot = filename.lastIndexOf(46);
        if (dot > (sep = FileUtils.getSeparatorIndex(filename))) {
            return filename.substring(sep + 1, dot);
        }
        return filename.substring(sep + 1);
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int dot = filename.lastIndexOf(46);
        if (dot == -1) {
            return filename;
        }
        int sep = FileUtils.getSeparatorIndex(filename);
        if (sep > dot) {
            return filename;
        }
        return filename.substring(0, dot);
    }

    private static int getSeparatorIndex(String filename) {
        int unixSep;
        int winSep = filename.lastIndexOf(92);
        return winSep > (unixSep = filename.lastIndexOf(47)) ? winSep : unixSep;
    }
}

