/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openl.util.RuntimeExceptionWrapper;

public class StringTool {
    public static final String NEW_LINE = "\n";
    private static final String COMMA = ",";
    public static Convertor IGNORE = new Convertor(){

        @Override
        public void convert(char c, int idx, StringBuilder out) {
        }
    };
    public static Convertor UPPER = new Convertor(){

        @Override
        public void convert(char c, int idx, StringBuilder out) {
            out.append(Character.toUpperCase(c));
        }
    };
    public static Convertor LOWER = new Convertor(){

        @Override
        public void convert(char c, int idx, StringBuilder out) {
            out.append(Character.toLowerCase(c));
        }
    };
    public static final MacroKeyHandler MKH_DONOTHING = new MacroKeyHandler(){

        @Override
        public void handleKey(String key, MacroSubst ms, StringBuilder out) {
        }
    };
    public static final MacroKeyHandler MKH_LEAVE = new MacroKeyHandler(){

        @Override
        public void handleKey(String key, MacroSubst ms, StringBuilder out) {
            out.append(ms._macroDelim).append(key).append(ms._macroDelim);
        }
    };
    public static final MacroKeyHandler MKH_ERROR = new MacroKeyHandler(){

        @Override
        public void handleKey(String key, MacroSubst ms, StringBuilder out) {
            throw new RuntimeException("Key " + key + " not found");
        }
    };

    public static StringBuilder append(StringBuilder buf, char c, int n) {
        for (int i = 0; i < n; ++i) {
            buf.append(c);
        }
        return buf;
    }

    public static String byteArrayToHexString(byte[] src, int off, int len) {
        StringBuilder out = new StringBuilder();
        for (int i = off; i < off + len; ++i) {
            String s = Integer.toHexString(src[i] & 0xFF);
            if (s.length() % 2 != 0) {
                out.append("0");
            }
            out.append(s);
        }
        return out.toString();
    }

    public static String decapitalizeName(String capitalized, String separator) {
        return StringTool.decapitalizeName(capitalized, separator, new StringBuilder()).toString();
    }

    public static StringBuilder decapitalizeName(String capitalized, String separator, StringBuilder buf) {
        if (capitalized == null) {
            return buf;
        }
        if (separator == null) {
            separator = "";
        }
        int start = 0;
        boolean prevUP = false;
        char[] src = capitalized.toCharArray();
        for (int i = 0; i < src.length; ++i) {
            char c = src[i];
            if (Character.isUpperCase(c)) {
                if (!prevUP) {
                    prevUP = true;
                    if (i > start) {
                        buf.append(src, start, i - start);
                        start = i;
                        buf.append(separator);
                    }
                }
                src[i] = Character.toLowerCase(c);
                continue;
            }
            if (!prevUP) continue;
            prevUP = false;
            int len = i - start;
            if (len <= 1) continue;
            buf.append(src, start, len - 1);
            start = i - 1;
            buf.append(separator);
        }
        buf.append(src, start, src.length - start);
        return buf;
    }

    public static String encodeURL(String url) {
        String encodedUrl = null;
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        try {
            encodedUrl = URLEncoder.encode(url, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodedUrl;
    }

    public static String decodeURL(String url) {
        String decodedUrl = null;
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        try {
            decodedUrl = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return decodedUrl;
    }

    public static String filter(String src, Selector sel, Convertor conv) {
        return StringTool.filter(src, sel, conv, new StringBuilder()).toString();
    }

    public static StringBuilder filter(String src, Selector sel, Convertor conv, StringBuilder buf) {
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (!sel.select(c, i)) {
                conv.convert(c, i, buf);
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    public static String firstToken(String src, String delim) {
        String[] tokens = StringTool.tokenize(src, delim);
        return tokens.length > 0 ? tokens[0] : "";
    }

    public static int indexOfClosingBracket(String src, char openingBracket, char closingBracket, int fromIndex) {
        int len = src.length();
        int cnt = 1;
        for (int i = fromIndex; i < len; ++i) {
            char c = src.charAt(i);
            if (c == closingBracket) {
                if (--cnt != 0) continue;
                return i;
            }
            if (c != openingBracket) continue;
            ++cnt;
        }
        return -1;
    }

    public static boolean isSpace(char c) {
        return c <= ' ' || Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    public static String keepChars(String src, String toKeep) {
        StringBuilder buf = new StringBuilder(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (toKeep.indexOf(c) < 0) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String lastToken(String src, String delim) {
        String[] tokens = StringTool.tokenize(src, delim);
        return tokens.length > 0 ? tokens[tokens.length - 1] : "";
    }

    public static String macroSubst(String src, Map<String, String> macros, char macroDelim, MacroKeyHandler mkh) {
        return StringTool.macroSubst(src, macros, macroDelim, mkh, new StringBuilder()).toString();
    }

    public static StringBuilder macroSubst(String src, Map<String, String> macros, char macroDelim, MacroKeyHandler mkh, StringBuilder buf) {
        MacroSubst ms = new MacroSubst(macros, macroDelim, mkh);
        return ms.transform(src, buf);
    }

    public static String makeJavaIdentifier(String src) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (i == 0) {
                buf.append(Character.isJavaIdentifierStart(c) ? c : (char)'_');
                continue;
            }
            buf.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return buf.toString();
    }

    public static String[] openBrackets(String src, char openingBracket, char closingBracket, String ignore) {
        int len = src.length();
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == openingBracket) {
                int closed = StringTool.indexOfClosingBracket(src, openingBracket, closingBracket, i + 1);
                if (closed == -1) {
                    throw new RuntimeException("Expected: " + closingBracket);
                }
                v.add(src.substring(i + 1, closed));
                i = closed;
                continue;
            }
            if (ignore.indexOf(c) != -1) continue;
            throw new RuntimeException("UnExpected: " + c);
        }
        return v.toArray(new String[v.size()]);
    }

    public static String replace(String src, String toFind, String toReplace) {
        return StringTool.replace(src, toFind, toReplace, true, false, new StringBuilder()).toString();
    }

    public static StringBuilder replace(String src, String toFind, String toReplace, boolean all, boolean ignoreCase, StringBuilder out) {
        int idx;
        int find_len = toFind.length();
        int src_len = src.length();
        int replace_len = toReplace.length();
        int start = 0;
        String test_src = src;
        String test_tofind = toFind;
        if (ignoreCase) {
            test_src = src.toLowerCase();
            test_tofind = toFind.toLowerCase();
        }
        while (start + find_len <= src_len && (idx = test_src.indexOf(test_tofind, start)) >= 0) {
            if (start != idx) {
                out.append(src.substring(start, idx));
            }
            if (replace_len > 0) {
                out.append(toReplace);
            }
            start = idx + find_len;
            if (all) continue;
            break;
        }
        if (start < src_len) {
            out.append(src.substring(start));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] splitLines(Reader reader) {
        String[] stringArray;
        BufferedReader br = new BufferedReader(reader);
        ArrayList<String> v = new ArrayList<String>();
        try {
            String s;
            while ((s = br.readLine()) != null) {
                v.add(s);
            }
            stringArray = v.toArray(new String[v.size()]);
        }
        catch (Throwable throwable) {
            try {
                br.close();
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrap(e);
            }
        }
        br.close();
        return stringArray;
    }

    public static String[] splitLines(String src) {
        return StringTool.splitLines(new StringReader(src));
    }

    public static String[] tokenize(String src, String delim) {
        StringTokenizer st = new StringTokenizer(src, delim);
        int cnt = st.countTokens();
        String[] res = new String[cnt];
        for (int i = 0; i < res.length; ++i) {
            res[i] = st.nextToken();
        }
        return res;
    }

    public static String untab(String src, int tabSize) {
        StringBuilder buf = new StringBuilder(src.length() + 10);
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c != '\t') {
                buf.append(c);
                continue;
            }
            buf.append(' ');
            int extra = buf.length() % tabSize;
            if (extra == 0) continue;
            StringTool.append(buf, ' ', tabSize - extra);
        }
        return buf.toString();
    }

    public static String getFileNameOfJavaClass(Class<?> c) {
        return c.getName().replace('.', '/') + ".java";
    }

    public static String[] splitAndEscape(String src, String splitSymbol, String escapeSymbol) {
        String[] result;
        String[] tokens = src.split(splitSymbol);
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        if (escapeSymbol != null) {
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].endsWith(escapeSymbol)) {
                    String noEscapeToken = tokens[i].substring(0, tokens[i].length() - 1);
                    buf.append(noEscapeToken).append(splitSymbol);
                    continue;
                }
                if (buf.length() == 0) {
                    tokens[i] = tokens[i].trim();
                    resultList.add(tokens[i]);
                    continue;
                }
                buf.append(tokens[i]);
                resultList.add(buf.toString());
                buf.delete(0, buf.length());
            }
            result = resultList.toArray(new String[0]);
        } else {
            result = tokens;
        }
        return result;
    }

    public static String insertStringToString(String baseStr, String strToInsertBefore, String insertion) {
        String src = baseStr;
        String[] tokens = src.split(strToInsertBefore);
        StringBuilder strBuf = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            strBuf.append(token);
            if (i == tokens.length - 1) continue;
            strBuf.append(insertion);
            strBuf.append(strToInsertBefore);
        }
        return strBuf.toString();
    }

    public static String arrayToStringThroughSymbol(Object[] values, String symbol) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean prependComma = false;
        for (Object value : values) {
            if (prependComma) {
                builder.append(symbol);
            }
            builder.append(value);
            prependComma = true;
        }
        return builder.toString();
    }

    public static String getSetterName(String fieldName) {
        StringBuilder builder = new StringBuilder(64);
        return builder.append("set").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1)).toString();
    }

    public static String getGetterName(String fieldName) {
        StringBuilder builder = new StringBuilder(64);
        return builder.append("get").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1)).toString();
    }

    public static final String buildTypeName(String namespace, String typeName) {
        StringBuilder builder = new StringBuilder(64);
        return builder.append(namespace).append("::").append(typeName).toString();
    }

    public static class TextTransformer {
        public static final char EOF = '\uffff';
        protected char prev = (char)65535;
        protected char cur = (char)65535;
        protected char next = (char)65535;
        protected StringBuilder out = null;
        private StringBuilder tmp = null;
        protected int len = -1;
        protected int status = 0;
        protected int idx = 0;

        public String flushTmp() {
            String s = this.tmp().toString();
            this.tmp.setLength(0);
            return s;
        }

        public void process() {
            this.out.append(this.cur);
        }

        public final StringBuilder tmp() {
            if (this.tmp == null) {
                this.tmp = new StringBuilder();
            }
            return this.tmp;
        }

        public String transform(String src) {
            return this.transform(src, new StringBuilder()).toString();
        }

        public StringBuilder transform(String src, StringBuilder buf) {
            this.out = buf;
            this.len = src.length();
            if (this.len > 0) {
                this.next = src.charAt(0);
            }
            this.idx = 0;
            while (this.idx < this.len) {
                this.prev = this.cur;
                this.cur = this.next;
                this.next = (char)(this.idx + 1 < this.len ? (int)src.charAt(this.idx + 1) : 65535);
                this.process();
                ++this.idx;
            }
            this.veryEnd();
            return this.out;
        }

        public void veryEnd() {
        }
    }

    public static interface Selector {
        public boolean select(char var1, int var2);
    }

    public static class MacroSubst
    extends TextTransformer {
        public char _macroDelim;
        public Map<String, String> _macros;
        MacroKeyHandler _mkh;

        public MacroSubst(Map<String, String> macros, char macroDelim, MacroKeyHandler mkh) {
            this._macros = macros;
            this._macroDelim = macroDelim;
            this._mkh = mkh;
        }

        @Override
        public void process() {
            if (this.cur == this._macroDelim) {
                if (this.status == 0) {
                    this.status = 1;
                } else {
                    this.status = 0;
                    String key = this.flushTmp();
                    String res = this._macros.get(key);
                    if (res == null) {
                        this._mkh.handleKey(key, this, this.out);
                    } else {
                        this.out.append(res);
                    }
                }
            } else if (this.status == 0) {
                this.out.append(this.cur);
            } else {
                this.tmp().append(this.cur);
            }
        }
    }

    public static interface MacroKeyHandler {
        public void handleKey(String var1, MacroSubst var2, StringBuilder var3);
    }

    public static interface Convertor {
        public void convert(char var1, int var2, StringBuilder var3);
    }
}

