/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openl.util.IOUtils;

public class ZipUtils {
    private static final int BUFFER_SIZE = 65536;

    public static void extractAll(File zipFile, File outputFolder) throws IOException {
        FileInputStream zippedStream = new FileInputStream(zipFile);
        ZipUtils.extractAll(zippedStream, outputFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractAll(InputStream zippedStream, File outputFolder) throws IOException {
        byte[] buffer = new byte[65536];
        ZipInputStream zis = new ZipInputStream(zippedStream);
        try {
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    String fileName = ze.getName();
                    File unzipped = new File(outputFolder, fileName);
                    new File(unzipped.getParent()).mkdirs();
                    FileOutputStream fos = new FileOutputStream(unzipped);
                    IOUtils.copy(zis, fos, buffer);
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            IOUtils.closeQuietly(zis);
        }
    }

    public static void archive(File sourceDirectory, File targetFile) throws IOException {
        String[] list;
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException("File '" + sourceDirectory.getAbsolutePath() + "' is not exist!");
        }
        if (sourceDirectory.isDirectory() && ((list = sourceDirectory.list()) == null || list.length == 0)) {
            throw new FileNotFoundException("Directory '" + sourceDirectory.getAbsolutePath() + "' is empty!");
        }
        FileOutputStream fos = new FileOutputStream(targetFile);
        try {
            ZipUtils.archive(sourceDirectory, fos);
        }
        finally {
            ((OutputStream)fos).close();
        }
    }

    private static void archive(File source, OutputStream output) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(output);
        byte[] buffer = new byte[65536];
        if (source.isDirectory()) {
            String sourceDirAbsolutePath = source.getAbsolutePath() + File.separator;
            int prefixLength = sourceDirAbsolutePath.length();
            LinkedList<File> directoryList = new LinkedList<File>();
            directoryList.add(source);
            while (!directoryList.isEmpty()) {
                File[] files;
                File directory = (File)directoryList.poll();
                for (File file : files = directory.listFiles()) {
                    String entryName = file.getAbsolutePath().substring(prefixLength);
                    entryName = entryName.replaceAll("\\\\", "/");
                    if (file.isDirectory()) {
                        if (file.listFiles().length == 0) {
                            ZipEntry entry = new ZipEntry(entryName + "/");
                            zos.putNextEntry(entry);
                            continue;
                        }
                        directoryList.add(file);
                        continue;
                    }
                    ZipUtils.archiveFile(file, entryName, zos, buffer);
                }
            }
        } else {
            String name = source.getName();
            ZipUtils.archiveFile(source, name, zos, buffer);
        }
        zos.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void archiveFile(File file, String name, ZipOutputStream zos, byte[] data) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            ZipEntry entry = new ZipEntry(name);
            zos.putNextEntry(entry);
            IOUtils.copy(fis, zos, data);
        }
        finally {
            fis.close();
        }
    }
}

