/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.benchmark;

import java.util.ArrayList;
import java.util.List;
import org.openl.util.Log;
import org.openl.util.benchmark.BenchmarkInfo;
import org.openl.util.benchmark.BenchmarkUnit;

public class Benchmark {
    public List<BenchmarkInfo> measureAllInList(BenchmarkUnit[] units, int ms) throws Exception {
        ArrayList<BenchmarkInfo> list = new ArrayList<BenchmarkInfo>();
        for (BenchmarkUnit bu : units) {
            Log.info("Benchmarking Unit " + bu.getName());
            BenchmarkInfo bi = this.runUnit(bu, ms);
            list.add(bi);
        }
        return list;
    }

    public BenchmarkInfo runUnit(BenchmarkUnit bu, int ms) throws Exception {
        BenchmarkInfo bi = new BenchmarkInfo(null, bu, bu.getName());
        bi.firstRunms = bu.millisecondsToRun();
        int minMillis = ms == -1 ? bu.getMinms() : ms;
        long runs = bu.getMinRuns();
        while (true) {
            long time;
            if ((time = bu.millisecondsToRun(runs)) > (long)minMillis || runs >= Integer.MAX_VALUE) {
                bi.collect(runs, time);
                return bi;
            }
            double mult = Math.min(200.0, 1.1 * (double)minMillis / (double)time);
            runs = Math.max(runs + 1L, (long)((double)runs * mult));
            runs = Math.min(runs, Integer.MAX_VALUE);
        }
    }
}

