/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.benchmark;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.openl.util.benchmark.BenchmarkOrder;
import org.openl.util.benchmark.BenchmarkUnit;

public class BenchmarkInfo {
    BenchmarkUnit unit;
    long firstRunms;
    Throwable error;
    String name;
    long timesSum;
    long msSum;
    double ms2Sum;

    public void collect(long times, long ms) {
        this.timesSum += times;
        this.msSum += ms;
        this.ms2Sum += (double)ms / (double)times * (double)ms;
    }

    public static BenchmarkOrder[] order(BenchmarkInfo[] bi) {
        ArrayList<BenchmarkOrder> list = new ArrayList<BenchmarkOrder>();
        for (int i = 0; i < bi.length; ++i) {
            if (bi[i] == null) continue;
            list.add(new BenchmarkOrder(i, bi[i]));
        }
        Collections.sort(list);
        BenchmarkOrder[] bo = list.toArray(new BenchmarkOrder[0]);
        for (int i = 0; i < bo.length; ++i) {
            bo[i].setOrder(i + 1);
            bo[i].setRatio(bo[0].info.drunsunitsec() / bo[i].info.drunsunitsec());
        }
        BenchmarkOrder[] bores = new BenchmarkOrder[bi.length];
        for (int i = 0; i < bo.length; ++i) {
            bores[bo[i].getIndex()] = bo[i];
        }
        return bores;
    }

    public static String printDouble(double d) {
        if (d >= 1000.0) {
            DecimalFormat fmt = new DecimalFormat("#,##0");
            return fmt.format(d);
        }
        if (d >= 1.0) {
            DecimalFormat fmt = new DecimalFormat("#,##0.00");
            return fmt.format(d);
        }
        if (d > 0.1) {
            return BenchmarkInfo.printDouble(d, 3);
        }
        if (d > 0.01) {
            return BenchmarkInfo.printDouble(d, 4);
        }
        if (d > 0.001) {
            return BenchmarkInfo.printDouble(d, 5);
        }
        return BenchmarkInfo.printDouble(d, 6);
    }

    public static String printDouble(double d, int decimals) {
        NumberFormat fmt = NumberFormat.getNumberInstance();
        fmt.setMaximumFractionDigits(decimals);
        fmt.setMinimumFractionDigits(decimals);
        return fmt.format(d);
    }

    public static String printLargeDouble(double d) {
        DecimalFormat fmt = new DecimalFormat("#,##0");
        return fmt.format(d);
    }

    public BenchmarkInfo(Throwable t, BenchmarkUnit bu, String name) {
        this.error = t;
        this.unit = bu;
        this.name = name;
    }

    public double avg() {
        return (double)this.msSum / (double)this.timesSum;
    }

    public double deviation() {
        return Math.sqrt((this.ms2Sum - (double)this.msSum / (double)this.timesSum * (double)this.msSum) / (double)this.timesSum);
    }

    public double drunsunitsec() {
        return (double)(1000 * this.unit.nUnitRuns()) / this.avg();
    }

    public Throwable getError() {
        return this.error;
    }

    public String getName() {
        return this.name;
    }

    public BenchmarkUnit getUnit() {
        return this.unit;
    }

    public String msrun() {
        return BenchmarkInfo.printDouble(this.avg());
    }

    public String msrununit() {
        return BenchmarkInfo.printDouble(this.avg() / (double)this.unit.nUnitRuns());
    }

    public String runssec() {
        return BenchmarkInfo.printLargeDouble(1000.0 / this.avg());
    }

    public String runsunitsec() {
        return BenchmarkInfo.printLargeDouble(this.drunsunitsec());
    }

    public String toString() {
        return this.getName() + " = \t" + this.msrun() + " ms/run\t" + this.runssec() + " runs/sec\t First Run: " + this.firstRunms + "ms";
    }
}

