/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.conf;

import org.apache.commons.lang3.StringUtils;

public class Version
implements Comparable<Version> {
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int VARIANT = 2;
    public static final int BUILD = 3;
    public static final String JAVA_VERSION_PATTERN = ".._";
    int[] version = new int[]{-1, -1, -1, -1};
    String pattern = ".._";

    public static int calcNumbersSeparatedByDots(String s, int from, String pattern) {
        int nnum = 0;
        int len = s.length();
        boolean inNumber = false;
        for (int i = from; i < len && nnum <= pattern.length(); ++i) {
            char c = s.charAt(i);
            if (inNumber) {
                if (Character.isDigit(c)) continue;
                inNumber = false;
                if (c != pattern.charAt(nnum - 1)) break;
                continue;
            }
            if (!Character.isDigit(c)) break;
            ++nnum;
            inNumber = true;
        }
        return nnum;
    }

    public static Version extractVersion(String vx) throws Exception {
        return Version.extractVersion(vx, JAVA_VERSION_PATTERN);
    }

    public static Version extractVersion(String s, IVersionStartPatternFinder finder, String pattern) throws Exception {
        int idx = Version.findVersionStart(s, finder, pattern);
        if (idx == -1) {
            throw new Exception("Could not find version pattern in " + s);
        }
        return Version.parseVersion(s, idx, pattern);
    }

    public static Version extractVersion(String s, String pattern) throws Exception {
        return Version.extractVersion(s, new StandardVersionStartPatternFinder(), pattern);
    }

    public static int findVersionStart(String s, IVersionStartPatternFinder finder, String pattern) {
        int idx = -1;
        int loopProtector = 0;
        do {
            if ((idx = finder.findVersionStart(s, idx)) == -1) {
                return -1;
            }
            if (!Version.isVersion(s, idx, pattern)) continue;
            return idx;
        } while (++loopProtector <= 100);
        throw new RuntimeException("Check implementation of Your Pattern Finder");
    }

    public static int findVersionStart(String s, String pattern) {
        return Version.findVersionStart(s, new StandardVersionStartPatternFinder(), pattern);
    }

    public static boolean isVersion(String t1, int i) {
        return Version.isVersion(t1, i, JAVA_VERSION_PATTERN);
    }

    public static boolean isVersion(String s, int from, String pattern) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        return Version.calcNumbersSeparatedByDots(s, from, pattern) == pattern.length() + 1;
    }

    public static Version parseVersion(String s, int i) {
        return Version.parseVersion(s, i, JAVA_VERSION_PATTERN);
    }

    public static Version parseVersion(String s, int from, String pattern) {
        if (!Version.isVersion(s, from, pattern)) {
            throw new RuntimeException("This is not a valid version: " + s.substring(from) + " in " + s);
        }
        Version v = new Version();
        v.setPattern(pattern);
        v.parseIn(s, from);
        return v;
    }

    public Version() {
    }

    public Version(int major, int minor, int variant, int build, String pattern) {
        this.version[0] = major;
        this.version[1] = minor;
        this.version[2] = variant;
        this.version[3] = build;
        if (pattern != null) {
            this.pattern = pattern;
        }
    }

    @Override
    public int compareTo(Version v) {
        for (int i = 0; i < this.version.length; ++i) {
            if (this.version[i] == v.version[i]) continue;
            return this.version[i] - v.version[i];
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        for (int i = 0; i < this.version.length; ++i) {
            if (this.version[i] == v.version[i]) continue;
            return false;
        }
        return true;
    }

    public int getBuild() {
        return this.version[3];
    }

    public int getMajor() {
        return this.version[0];
    }

    public int getMinor() {
        return this.version[1];
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getVariant() {
        return this.version[2];
    }

    public int hashCode() {
        return this.version[3] * 119 + this.version[2] * 37 + this.version[1] * 17 + this.version[0];
    }

    private void parseIn(String s, int from) {
        new Parser(s, from).parseVersion();
    }

    public void setBuild(int i) {
        this.version[3] = i;
    }

    public void setMajor(int i) {
        this.version[0] = i;
    }

    public void setMinor(int i) {
        this.version[1] = i;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setVariant(int i) {
        this.version[2] = i;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.version.length && this.version[i] >= 0; ++i) {
            buf.append(this.version[i]);
            if (i >= this.pattern.length()) continue;
            buf.append(this.pattern.charAt(i));
        }
        return buf.toString();
    }

    public static class StandardVersionStartPatternFinder
    implements IVersionStartPatternFinder {
        @Override
        public int findVersionStart(String s, int previousStart) {
            int idx;
            if (previousStart == -1 && (idx = s.lastIndexOf(95)) >= 0) {
                return idx + 1;
            }
            return -1;
        }
    }

    class Parser {
        int pos;
        String s;

        Parser(String s, int from) {
            this.s = s;
            this.pos = from;
        }

        int getInt() {
            char c;
            int len = this.s.length();
            if (this.pos >= len || !Character.isDigit(this.s.charAt(this.pos))) {
                return -1;
            }
            int n = 0;
            while (this.pos < len && Character.isDigit(c = this.s.charAt(this.pos))) {
                n = n * 10 + c - 48;
                ++this.pos;
            }
            ++this.pos;
            return n;
        }

        void parseVersion() {
            Version.this.version[0] = this.getInt();
            if (Version.this.version[0] < 0 || (Version.this.version[1] = this.getInt()) < 0 || (Version.this.version[2] = this.getInt()) >= 0) {
                // empty if block
            }
            Version.this.version[3] = this.getInt();
        }
    }

    public static interface IVersionStartPatternFinder {
        public int findVersionStart(String var1, int var2);
    }
}

