/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.generation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openl.util.generation.CharInitializationWriter;
import org.openl.util.generation.CommonInitializationWriter;
import org.openl.util.generation.DateInitializationWriter;
import org.openl.util.generation.DefaultConstructorInitWriter;
import org.openl.util.generation.DefaultEmptyArrayConstructorInitWriter;
import org.openl.util.generation.DefaultValue;
import org.openl.util.generation.JavaClassGeneratorHelper;
import org.openl.util.generation.JavaGenerator;
import org.openl.util.generation.NumberInitializationWriter;
import org.openl.util.generation.StringInitializationWriter;
import org.openl.util.generation.TypeInitializationWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBeanJavaGenerator
extends JavaGenerator {
    private final Logger log = LoggerFactory.getLogger(SimpleBeanJavaGenerator.class);
    private Map<String, Class<?>> datatypeDeclaredFields;
    private Map<String, Class<?>> datatypeAllFields;
    private static Map<Class<?>, TypeInitializationWriter> initializationWriters = new HashMap();

    public SimpleBeanJavaGenerator(Class<?> datatypeClass) {
        super(datatypeClass);
        this.datatypeDeclaredFields = new LinkedHashMap(this.getFieldsDescription(datatypeClass.getDeclaredFields()));
        this.datatypeAllFields = new LinkedHashMap(this.getFieldsDescription(FieldUtils.getAllFields(datatypeClass)));
    }

    private Map<String, Class<?>> getFieldsDescription(Field[] fields) {
        LinkedHashMap fieldsDescriprtion = new LinkedHashMap();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldsDescriprtion.put(field.getName(), field.getType());
        }
        return fieldsDescriprtion;
    }

    private void addJAXBAnnotations(StringBuilder buf) {
        this.addImport(buf, this.filterTypeNameForImport(XmlRootElement.class));
        this.addImport(buf, this.filterTypeNameForImport(XmlElement.class));
        this.addImport(buf, this.filterTypeNameForImport(XmlType.class));
        String packageName = ClassUtils.getPackageName((String)this.getClassNameForGeneration());
        String[] packageParts = packageName.split("\\.");
        StringBuilder namespace = new StringBuilder("http://");
        for (int i = packageParts.length - 1; i >= 0; --i) {
            namespace.append(packageParts[i]);
            if (i == 0) continue;
            namespace.append(".");
        }
        buf.append("\n@XmlRootElement(namespace=\"" + namespace.toString() + "\")");
        buf.append("\n@XmlType(namespace=\"" + namespace.toString() + "\")");
    }

    @Override
    public String generateJavaClass() {
        StringBuilder buf = new StringBuilder(10000);
        this.addComment(buf);
        this.addPackage(buf);
        this.addImports(buf);
        this.addJAXBAnnotations(buf);
        this.addClassDeclaration(buf, ClassUtils.getShortClassName((String)this.getClassNameForGeneration()), ClassUtils.getShortClassName(this.getClassForGeneration().getSuperclass()));
        this.addFieldsDeclaration(buf);
        this.addConstructors(buf);
        this.addMethods(buf);
        buf.append("\n}");
        return buf.toString();
    }

    private void addMethods(StringBuilder buf) {
        Method[] methods = this.getClassForGeneration().getDeclaredMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Method method : methods) {
            if (method.getName().startsWith("get")) {
                String fieldName = this.getFieldName(method.getName(), this.datatypeAllFields.keySet());
                String defaultFieldValue = null;
                try {
                    Field field = this.getClassForGeneration().getDeclaredField(fieldName);
                    DefaultValue defaultValueAnnotation = field.getAnnotation(DefaultValue.class);
                    if (defaultValueAnnotation != null) {
                        defaultFieldValue = defaultValueAnnotation.value();
                    }
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                if (!this.getterExists(method, this.datatypeAllFields.keySet())) continue;
                if (defaultFieldValue != null) {
                    buf.append("\n  @XmlElement(name=\"" + fieldName + "\", defaultValue=\"" + defaultFieldValue + "\")");
                } else {
                    buf.append("\n  @XmlElement(name=\"" + fieldName + "\", nillable=true)");
                }
                this.addGetter(buf, method, this.datatypeAllFields.keySet());
                continue;
            }
            if (method.getName().startsWith("set")) {
                this.addSetter(buf, method, this.datatypeAllFields.keySet());
                continue;
            }
            if (method.getName().equals("equals")) {
                buf.append(JavaClassGeneratorHelper.getEqualsMethod(this.getClassForGeneration().getSimpleName(), this.datatypeAllFields.keySet()));
                continue;
            }
            if (method.getName().startsWith("hashCode")) {
                buf.append(JavaClassGeneratorHelper.getHashCodeMethod(this.datatypeAllFields.keySet()));
                continue;
            }
            if (!method.getName().equals("toString")) continue;
            buf.append(JavaClassGeneratorHelper.getToStringMethod(this.getClassForGeneration().getSimpleName(), this.datatypeAllFields));
        }
    }

    private void addConstructors(StringBuilder buf) {
        buf.append(JavaClassGeneratorHelper.getDefaultConstructor(this.getClassForGeneration().getSimpleName()));
        LinkedHashMap fieldsForConstructor = new LinkedHashMap();
        int numberOfParamsForSuperConstructor = 0;
        if (!this.getClassForGeneration().getSuperclass().equals(Object.class)) {
            numberOfParamsForSuperConstructor = this.datatypeAllFields.size() - this.datatypeDeclaredFields.size();
            Constructor<?> superConstructorWithFields = JavaClassGeneratorHelper.getConstructorByFieldsCount(this.getClassForGeneration().getSuperclass(), numberOfParamsForSuperConstructor);
            if (superConstructorWithFields != null) {
                int i = 0;
                for (Map.Entry<String, Class<?>> field : this.datatypeAllFields.entrySet()) {
                    if (field.getValue() != superConstructorWithFields.getParameterTypes()[i]) {
                        fieldsForConstructor.clear();
                        numberOfParamsForSuperConstructor = 0;
                    } else {
                        fieldsForConstructor.put(field.getKey(), field.getValue());
                        if (++i != numberOfParamsForSuperConstructor) continue;
                    }
                    break;
                }
            } else {
                numberOfParamsForSuperConstructor = 0;
            }
        }
        fieldsForConstructor.putAll(this.datatypeDeclaredFields);
        buf.append(JavaClassGeneratorHelper.getConstructorWithFields(this.getClassForGeneration().getSimpleName(), fieldsForConstructor, numberOfParamsForSuperConstructor));
    }

    private void addFieldsDeclaration(StringBuilder buf) {
        Object datatypeInstance = null;
        try {
            datatypeInstance = this.getClassForGeneration().newInstance();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        Field[] fields = this.getClassForGeneration().getDeclaredFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            Object fieldValue = this.getFieldValue(datatypeInstance, field.getName());
            if (fieldValue != null) {
                TypeInitializationWriter writer = this.getFieldValueWriter(field);
                if (writer == null) {
                    this.log.error("Can`t write value for {} field of type {}", fieldValue, (Object)fieldType.getName());
                    continue;
                }
                String valueInitialzation = writer.getInitialization(fieldValue);
                buf.append(JavaClassGeneratorHelper.getProtectedFieldInitialzation(JavaClassGeneratorHelper.filterTypeName(fieldType), field.getName(), valueInitialzation));
                continue;
            }
            buf.append(JavaClassGeneratorHelper.getProtectedFieldDeclaration(JavaClassGeneratorHelper.filterTypeName(fieldType), field.getName()));
        }
    }

    private TypeInitializationWriter getFieldValueWriter(Field field) {
        Class<?> fieldValueClass = field.getType();
        TypeInitializationWriter writer = initializationWriters.get(fieldValueClass);
        if (writer == null) {
            if (ClassUtils.isAssignable(fieldValueClass, Number.class)) {
                writer = initializationWriters.get(Number.class);
            }
            DefaultValue defaultValueAnnotation = field.getAnnotation(DefaultValue.class);
            String defaultFieldValue = null;
            if (defaultValueAnnotation != null) {
                defaultFieldValue = defaultValueAnnotation.value();
            }
            if ("_DEFAULT_".equals(defaultFieldValue)) {
                writer = initializationWriters.get(MarkerClass.class);
            }
            if ("_EMPTY_".equals(defaultFieldValue) && fieldValueClass.isArray()) {
                writer = initializationWriters.get(EmptyArrayMarkerClass.class);
            }
        }
        return writer;
    }

    private Object getFieldValue(Object datatypeInstance, String fieldName) {
        Object fieldValue = null;
        try {
            Field field = this.getClassForGeneration().getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldValue = field.get(datatypeInstance);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return fieldValue;
    }

    static {
        initializationWriters.put(Byte.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Short.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Integer.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Long.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Float.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Double.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Boolean.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Byte.class, new CommonInitializationWriter());
        initializationWriters.put(Short.class, new CommonInitializationWriter());
        initializationWriters.put(Integer.class, new CommonInitializationWriter());
        initializationWriters.put(Long.class, new CommonInitializationWriter());
        initializationWriters.put(Float.class, new CommonInitializationWriter());
        initializationWriters.put(Double.class, new CommonInitializationWriter());
        initializationWriters.put(Boolean.class, new CommonInitializationWriter());
        initializationWriters.put(Date.class, new DateInitializationWriter());
        initializationWriters.put(Number.class, new NumberInitializationWriter());
        initializationWriters.put(String.class, new StringInitializationWriter());
        initializationWriters.put(Character.TYPE, new CharInitializationWriter());
        initializationWriters.put(Character.class, new CharInitializationWriter());
        initializationWriters.put(MarkerClass.class, new DefaultConstructorInitWriter());
        initializationWriters.put(MarkerClass.class, new DefaultConstructorInitWriter());
        initializationWriters.put(EmptyArrayMarkerClass.class, new DefaultEmptyArrayConstructorInitWriter());
    }

    private final class EmptyArrayMarkerClass {
        private EmptyArrayMarkerClass() {
        }
    }

    private final class MarkerClass {
        private MarkerClass() {
        }
    }
}

