/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.print;

import java.util.HashMap;
import java.util.Stack;
import org.openl.util.print.ICategorizedSearchContext;

public class CategorizedSearchContext
implements ICategorizedSearchContext {
    private static ThreadLocal<Stack<ICategorizedSearchContext>> contexts = new ThreadLocal();
    private static CategorizedSearchContext defaultContext;
    private ICategorizedSearchContext parent;
    private HashMap<CKey, Object> map = new HashMap();

    public static ICategorizedSearchContext current() {
        Stack<ICategorizedSearchContext> s = contexts.get();
        if (s == null || s.size() == 0) {
            return CategorizedSearchContext.defaultSearchContext();
        }
        return s.peek();
    }

    private static synchronized ICategorizedSearchContext defaultSearchContext() {
        if (defaultContext == null) {
            defaultContext = new CategorizedSearchContext(null);
        }
        return defaultContext;
    }

    public static void push(ICategorizedSearchContext cxt) {
        Stack<ICategorizedSearchContext> s = contexts.get();
        if (s == null) {
            s = new Stack();
            contexts.set(s);
        }
        s.push(cxt);
    }

    public static void pushThis() {
        CategorizedSearchContext.push(new CategorizedSearchContext(CategorizedSearchContext.current()));
    }

    public CategorizedSearchContext(ICategorizedSearchContext context) {
        this.parent = context;
    }

    @Override
    public Object find(Object key, String category) {
        Object res = this.findLocal(key, category);
        if (res != null) {
            return res;
        }
        if (this.parent != null) {
            return this.parent.find(key, category);
        }
        return null;
    }

    public Object findLocal(Object key, String category) {
        CKey ckey = new CKey(key, category);
        return this.map.get(ckey);
    }

    @Override
    public ICategorizedSearchContext getParent() {
        return this.parent;
    }

    @Override
    public void register(Object key, String category, Object value) {
        this.map.put(new CKey(key, category), value);
    }

    @Override
    public void unregister(Object key, String category) {
        this.map.remove(new CKey(key, category));
    }

    private static class CKey {
        private Object key;
        private String category;

        CKey(Object key, String category) {
            this.key = key;
            this.category = category;
        }

        public boolean equals(Object obj) {
            CKey ckey = (CKey)obj;
            return this.key.equals(ckey.key) && this.category.equals(ckey.category);
        }

        public int hashCode() {
            return this.key.hashCode() + 37 * this.category.hashCode();
        }
    }
}

