/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.openl.domain.IIntIterator;
import org.openl.util.trie.IARTNode;

public class DepthFirstNodeIterator
implements Iterator<IARTNode> {
    Stack<IARTNode> nodeStack = new Stack();
    Stack<IIntIterator> iteratorStackN = new Stack();
    IARTNode current;
    IIntIterator iterator;

    public DepthFirstNodeIterator(IARTNode root) {
        this.current = root;
        this.iterator = root.indexIteratorN();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public IARTNode next() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        IARTNode res = this.current;
        this.findNext();
        return res;
    }

    private void findNext() {
        if (this.iterator.hasNext()) {
            int index = this.iterator.nextInt();
            IARTNode next = this.current.findNode(index);
            this.nodeStack.push(this.current);
            this.iteratorStackN.push(this.iterator);
            this.current = next;
            this.iterator = next.indexIteratorN();
            return;
        }
        while (!this.nodeStack.isEmpty()) {
            this.current = this.nodeStack.pop();
            this.iterator = this.iteratorStackN.pop();
            if (!this.iterator.hasNext()) continue;
            int index = this.iterator.nextInt();
            IARTNode next = this.current.findNode(index);
            this.nodeStack.push(this.current);
            this.iteratorStackN.push(this.iterator);
            this.current = next;
            this.iterator = next.indexIteratorN();
            return;
        }
        this.current = null;
    }
}

