/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie.cnodes;

public class CNodeFactory {
    public static int arraySize(Class<?> arrayClass, int size) {
        if (arrayClass == byte[].class) {
            return 16 + 8 * ((size + 7) / 8);
        }
        if (arrayClass == short[].class) {
            return 16 + 8 * ((size + 3) / 4);
        }
        if (arrayClass == char[].class) {
            return 16 + 8 * ((size + 3) / 4);
        }
        if (arrayClass == int[].class) {
            return 16 + 8 * ((size + 1) / 2);
        }
        if (arrayClass == double[].class) {
            return 16 + 8 * size;
        }
        if (arrayClass == long[].class) {
            return 16 + 8 * size;
        }
        if (arrayClass.isArray()) {
            return 16 + 8 * ((size + 1) / 2);
        }
        throw new RuntimeException("Unknown array type " + arrayClass.getName());
    }

    public static void main(String[] args) {
        CNodeFactory.check(byte[].class, 8);
        CNodeFactory.check(byte[].class, 9);
        CNodeFactory.check(byte[].class, 33);
        CNodeFactory.check(short[].class, 0);
        CNodeFactory.check(short[].class, 4);
        CNodeFactory.check(short[].class, 5);
        CNodeFactory.check(int[].class, 0);
        CNodeFactory.check(int[].class, 4);
        CNodeFactory.check(int[].class, 5);
        CNodeFactory.check(int[].class, 6);
    }

    private static void check(Class<?> aclass, int asize) {
        int size = CNodeFactory.arraySize(aclass, asize);
        System.out.println(aclass.getCanonicalName() + "[" + asize + "] = " + size);
    }

    public static boolean useMapper(int range, Class<?> mapperClass, int count, Class<?> valueClass) {
        int directSize;
        int mapperSize = CNodeFactory.arraySize(mapperClass, range) + CNodeFactory.arraySize(valueClass, count);
        return mapperSize * 10 < (directSize = CNodeFactory.arraySize(valueClass, range)) * 9;
    }
}

