/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie.ex;

public abstract class ARTNodeOld {
    protected ARTNodeOld[] child;
    public int count = 0;

    public int prefixLen() {
        return 0;
    }

    ARTNodeOld(int capacity) {
        this.child = new ARTNodeOld[capacity];
    }

    public boolean isFull() {
        return this.count >= this.capacity();
    }

    public abstract int capacity();

    public void replace(ARTNodeOld newNode, byte byteKey) {
        this.child[this.childIndex((byte)byteKey)] = newNode;
    }

    public ARTNodeOld findChild(byte byteKey) {
        int index = this.childIndex(byteKey);
        if (index < 0) {
            return null;
        }
        return this.child[index];
    }

    protected abstract int childIndex(byte var1);

    public void addChild(ARTNodeOld next, byte byteKey, int value) {
        int index = this.getNewChildIndex(byteKey);
        this.child[index] = next;
        ++this.count;
    }

    protected abstract int getNewChildIndex(byte var1);

    static class DirectNode
    extends ARTNodeOld {
        public DirectNode(int maxKeySize) {
            super(maxKeySize);
        }

        @Override
        protected int childIndex(byte byteKey) {
            return byteKey < 0 ? 127 - byteKey : byteKey;
        }

        @Override
        public int capacity() {
            return this.child.length;
        }

        @Override
        protected int getNewChildIndex(byte byteKey) {
            return this.childIndex(byteKey);
        }
    }

    static class MappingNode
    extends ARTNodeOld {
        private byte[] indexMap;

        public MappingNode(int maxKeySize, int maxChildSize) {
            super(maxChildSize);
            assert (maxKeySize <= 256);
            assert (maxChildSize < 127);
            this.indexMap = new byte[maxKeySize];
        }

        @Override
        public int capacity() {
            return this.child.length;
        }

        @Override
        protected int childIndex(byte byteKey) {
            return this.indexMap[byteKey < 0 ? 127 - byteKey : byteKey] - 1;
        }

        @Override
        protected int getNewChildIndex(byte byteKey) {
            int index = this.count;
            this.indexMap[byteKey < 0 ? 127 - byteKey : byteKey] = (byte)(index + 1);
            return index;
        }
    }

    static class SmallNode
    extends ARTNodeOld {
        private byte[] key;

        public SmallNode(int capacity) {
            super(capacity);
            this.key = new byte[capacity];
        }

        @Override
        public int capacity() {
            return this.child.length;
        }

        @Override
        protected int childIndex(byte byteKey) {
            for (int i = 0; i < this.count; ++i) {
                if (this.key[i] != byteKey) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected int getNewChildIndex(byte byteKey) {
            return this.count;
        }
    }
}

