/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.HashMap;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.LiteralNode;

public abstract class BusinessNumberNodeBinder
extends ANodeBinder {
    private static Map<Character, Integer> multiplierSuffixes = new HashMap<Character, Integer>();

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        assert (node instanceof LiteralNode);
        String literal = ((LiteralNode)node).getImage();
        if (literal.charAt(0) == '$') {
            literal = literal.substring(1);
        }
        if (literal.indexOf(44) >= 0) {
            literal = literal.replace(",", "");
        }
        int literalLength = literal.length();
        char lastCharacter = Character.toUpperCase(literal.charAt(literalLength - 1));
        IBoundNode parsedNumber = null;
        if (multiplierSuffixes.containsKey(Character.valueOf(lastCharacter))) {
            String literalWithoutSuffix = literal.substring(0, literalLength - 1);
            parsedNumber = this.makeNumber(literalWithoutSuffix, multiplierSuffixes.get(Character.valueOf(lastCharacter)), node);
        } else {
            parsedNumber = this.makeNumber(literal, 1, node);
        }
        return parsedNumber;
    }

    protected abstract IBoundNode makeNumber(String var1, int var2, ISyntaxNode var3) throws SyntaxNodeException;

    static {
        multiplierSuffixes.put(Character.valueOf('K'), 1000);
        multiplierSuffixes.put(Character.valueOf('M'), 1000000);
        multiplierSuffixes.put(Character.valueOf('B'), 1000000000);
    }
}

