/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.FieldBoundNode;
import org.openl.binding.impl.TypeBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;

public class ChainBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        LongNameBuilder builder = new LongNameBuilder(node, bindingContext);
        builder.bindName();
        int n = node.getNumberOfChildren();
        IBoundNode target = builder.targetNode;
        if (target == null) {
            if (builder.cnt > 0) {
                String message = "Can not resolve: " + builder.name;
                BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext);
                return new ErrorBoundNode(node);
            }
            target = ChainBinder.bindChildNode((ISyntaxNode)node.getChild(0), (IBindingContext)bindingContext);
            builder.cnt = 1;
        }
        for (int i = builder.cnt; i < n; ++i) {
            target = ChainBinder.bindTargetNode((ISyntaxNode)node.getChild(i), (IBindingContext)bindingContext, (IBoundNode)target);
        }
        return target;
    }

    static class LongNameBuilder {
        ISyntaxNode node;
        IBindingContext bindingContext;
        int cnt = 0;
        String name = "";
        IBoundNode targetNode;

        LongNameBuilder(ISyntaxNode node, IBindingContext bindingContext) {
            this.node = node;
            this.bindingContext = bindingContext;
        }

        void bindName() {
            int n = this.node.getNumberOfChildren();
            while (this.cnt < n) {
                ISyntaxNode child = this.node.getChild(this.cnt);
                if (!child.getType().equals("identifier")) {
                    return;
                }
                this.name = this.name + ((IdentifierNode)child).getIdentifier();
                IOpenField field = this.bindingContext.findVar("org.openl.this", this.name, true);
                if (field != null) {
                    ++this.cnt;
                    this.targetNode = new FieldBoundNode(child, field);
                    return;
                }
                IOpenClass type = this.bindingContext.findType("org.openl.this", this.name);
                if (type != null) {
                    ++this.cnt;
                    this.targetNode = new TypeBoundNode(child, type);
                    return;
                }
                ++this.cnt;
                this.name = this.name + '.';
            }
        }
    }
}

