/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.binding.impl.StringNodeBinder;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.LiteralNode;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class CharNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        String s = ((LiteralNode)node).getImage();
        char c = s.charAt(1);
        try {
            if (c == '\\') {
                char nextC = s.charAt(2);
                switch (nextC) {
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case '\"': {
                        c = '\"';
                        break;
                    }
                    case '\'': {
                        c = '\'';
                        break;
                    }
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case 'u': {
                        c = StringNodeBinder.processUnicode((String)s, (int)3);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char cc;
                        int res = 0;
                        for (int i = 0; i < 3 && '0' <= (cc = s.charAt(2 + i)) && cc <= '7'; ++i) {
                            res = res * 8 + cc - 48;
                            c = (char)res;
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            BindHelper.processError((ISyntaxNode)node, (Throwable)ex, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        return new LiteralBoundNode(node, (Object)new Character(c), (IOpenClass)JavaOpenClass.CHAR);
    }
}

