/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.FieldBoundNode;
import org.openl.binding.impl.MultiCallFieldAccessMethodBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldAccessMethodBinder
extends ANodeBinder {
    private String methodName;
    private IBoundNode[] children;
    private final Logger log = LoggerFactory.getLogger(FieldAccessMethodBinder.class);

    public FieldAccessMethodBinder(String methodName, IBoundNode[] children) {
        this.methodName = methodName;
        this.children = (IBoundNode[])children.clone();
    }

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        ISyntaxNode argumentNode = node.getChild(0);
        IOpenClass argumentType = this.getArgumentType();
        String fieldName = this.getAsFieldName(this.methodName);
        IBoundNode accessorChain = argumentType.isArray() ? this.bindArrayArgument(fieldName, bindingContext, argumentNode, argumentType.getComponentClass()) : this.bindSingleArgument(fieldName, argumentNode, bindingContext);
        if (accessorChain == null) {
            this.log.warn("Can`t bind as field access method the method with name {}", (Object)this.methodName);
        }
        return accessorChain;
    }

    private IOpenClass getArgumentType() {
        IOpenClass[] types = FieldAccessMethodBinder.getTypes((IBoundNode[])this.children);
        return types[0];
    }

    private IBoundNode bindArrayArgument(String fieldName, IBindingContext bindingContext, ISyntaxNode argumentNode, IOpenClass argumentComponentType) {
        IBoundNode containerField = FieldAccessMethodBinder.bindChildNode((ISyntaxNode)argumentNode, (IBindingContext)bindingContext);
        IOpenField field = bindingContext.findFieldFor(argumentComponentType, fieldName, false);
        if (field == null) {
            return null;
        }
        return new MultiCallFieldAccessMethodBoundNode(argumentNode.getParent(), containerField, field);
    }

    private IBoundNode bindSingleArgument(String fieldName, ISyntaxNode argumentNode, IBindingContext bindingContext) {
        IBoundNode target = FieldAccessMethodBinder.bindChildNode((ISyntaxNode)argumentNode, (IBindingContext)bindingContext);
        IOpenField field = bindingContext.findFieldFor(target.getType(), fieldName, false);
        if (field != null) {
            return new FieldBoundNode(argumentNode.getParent(), field, target);
        }
        return null;
    }

    private String getAsFieldName(String methodName) {
        return String.format("%s%s", methodName.substring(0, 1).toLowerCase(), methodName.substring(1));
    }
}

