/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.binding.impl.MethodSearch;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;

public class NewNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        int childrenCount = node.getNumberOfChildren();
        if (childrenCount < 1) {
            BindHelper.processError((String)"New node must have at least one subnode", (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        ISyntaxNode typeNode = node.getChild(0);
        String typeName = ((IdentifierNode)typeNode).getIdentifier();
        IOpenClass type = bindingContext.findType("org.openl.this", typeName);
        if (type == null) {
            String message = String.format("Type '%s' not found", typeName);
            BindHelper.processError((String)message, (ISyntaxNode)typeNode, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        IBoundNode[] children = NewNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext, (int)1, (int)childrenCount);
        IOpenClass[] types = NewNodeBinder.getTypes((IBoundNode[])children);
        IMethodCaller methodCaller = MethodSearch.getMethodCaller((String)type.getName(), (IOpenClass[])types, (ICastFactory)bindingContext, (IMethodFactory)type);
        if (methodCaller == null) {
            String errMsg = "Constructor not found: " + MethodUtil.printMethod((String)type.getName(), (IOpenClass[])types);
            BindHelper.processError((String)errMsg, (ISyntaxNode)typeNode, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        return new MethodBoundNode(node, children, methodCaller);
    }
}

