/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.RangeWithBounds;

public class RangeNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode[] children;
        for (IBoundNode child : children = RangeNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext)) {
            if (!(child instanceof ErrorBoundNode)) continue;
            return new ErrorBoundNode(node);
        }
        RangeWithBounds range = null;
        String type = node.getType();
        if (type.contains("brackets")) {
            range = this.bindBrackets(children, bindingContext);
        } else if (type.contains("binary")) {
            range = this.bindBinary(children, type, bindingContext);
        } else if (type.contains("number")) {
            range = this.bindNumber(children, bindingContext);
        } else if (type.contains("unary.prefix")) {
            range = this.bindPrefix(children, type, bindingContext);
        } else if (type.contains("unary.suffix")) {
            range = this.bindSuffix(children, type, bindingContext);
        }
        if (range == null) {
            String message = String.format("Unsupported range type: %s", type);
            BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        return new LiteralBoundNode(node, (Object)range, (IOpenClass)JavaOpenClass.getOpenClass(RangeWithBounds.class));
    }

    private RangeWithBounds bindBrackets(IBoundNode[] children, IBindingContext bindingContext) {
        int minBoundIndex = -1;
        int maxBoundIndex = -1;
        Number firstNumber = null;
        Number secondNumber = null;
        RangeWithBounds.BoundType leftBoundType = null;
        RangeWithBounds.BoundType rightBoundType = null;
        for (int i = 0; i < children.length; ++i) {
            Object value = ((LiteralBoundNode)children[i]).getValue();
            if (value instanceof Number) {
                if (firstNumber == null) {
                    firstNumber = (Number)value;
                    continue;
                }
                secondNumber = (Number)value;
                continue;
            }
            if (value.equals(Character.valueOf('[')) || value.equals(Character.valueOf('('))) {
                minBoundIndex = i;
                leftBoundType = value.equals(Character.valueOf('(')) ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
                continue;
            }
            if (!value.equals(Character.valueOf(']')) && !value.equals(Character.valueOf(')'))) continue;
            maxBoundIndex = i;
            rightBoundType = value.equals(Character.valueOf(')')) ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
        }
        if (minBoundIndex == maxBoundIndex || minBoundIndex < 0 || maxBoundIndex < 0) {
            throw new OpenLRuntimeException("Incorrect range format");
        }
        Number min = minBoundIndex < 2 ? (Number)firstNumber : (Number)secondNumber;
        Number max = maxBoundIndex < 2 ? (Number)firstNumber : (Number)secondNumber;
        return new RangeWithBounds(min, max, leftBoundType, rightBoundType);
    }

    private RangeWithBounds bindBinary(IBoundNode[] children, String type, IBindingContext bindingContext) {
        Number val = (Number)((LiteralBoundNode)children[0]).getValue();
        Number val2 = (Number)((LiteralBoundNode)children[1]).getValue();
        if (val.doubleValue() > val2.doubleValue()) {
            throw new OpenLRuntimeException(String.format("%s must be more or equal than %s", val2.toString(), val.toString()));
        }
        if (type.endsWith("minus") || type.endsWith("ddot")) {
            return new RangeWithBounds(val, val2);
        }
        if (type.endsWith("tdot")) {
            return new RangeWithBounds(val, val2, RangeWithBounds.BoundType.EXCLUDING, RangeWithBounds.BoundType.EXCLUDING);
        }
        return null;
    }

    private RangeWithBounds bindNumber(IBoundNode[] children, IBindingContext bindingContext) {
        Number val = (Number)((LiteralBoundNode)children[0]).getValue();
        return new RangeWithBounds(val, val);
    }

    private RangeWithBounds bindPrefix(IBoundNode[] children, String type, IBindingContext bindingContext) {
        Number val = (Number)((LiteralBoundNode)children[0]).getValue();
        if (type.endsWith("lt")) {
            return new RangeWithBounds(this.getMin(val), val, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.EXCLUDING);
        }
        if (type.endsWith("le")) {
            return new RangeWithBounds(this.getMin(val), val, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        if (type.endsWith("gt")) {
            return new RangeWithBounds(val, this.getMax(val), RangeWithBounds.BoundType.EXCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        if (type.endsWith("ge")) {
            return new RangeWithBounds(val, this.getMax(val), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        return null;
    }

    private RangeWithBounds bindSuffix(IBoundNode[] children, String type, IBindingContext bindingContext) {
        Number val = (Number)((LiteralBoundNode)children[0]).getValue();
        if (type.endsWith("plus") || type.endsWith("and.more")) {
            return new RangeWithBounds(val, this.getMax(val), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        if (type.endsWith("or.less")) {
            return new RangeWithBounds(this.getMin(val), val, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        return null;
    }

    private Number getMax(Number number) {
        if (number.getClass() == Double.class) {
            return Double.POSITIVE_INFINITY;
        }
        if (number.getClass() == Long.class) {
            return Long.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private Number getMin(Number number) {
        if (number.getClass() == Double.class) {
            return Double.NEGATIVE_INFINITY;
        }
        if (number.getClass() == Long.class) {
            return Long.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }
}

