/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.VariableArgumentsMethodBoundNode;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;

public class VariableLengthArgumentsMethodBinder
extends ANodeBinder {
    private String methodName;
    private IOpenClass[] argumentsTypes;
    private IBoundNode[] children;

    public VariableLengthArgumentsMethodBinder(String methodName, IOpenClass[] argumentsTypes, IBoundNode[] children) {
        this.methodName = methodName;
        if (argumentsTypes == null || argumentsTypes.length < 1) {
            String message = String.format("At least one argument should exist in method signature(%s) to bind it as variable arguments method", methodName);
            throw new OpenlNotCheckedException(message);
        }
        this.argumentsTypes = (IOpenClass[])argumentsTypes.clone();
        if (children == null) {
            String message = String.format("Chldren nodes for method %s cannot be null", methodName);
            throw new OpenlNotCheckedException(message);
        }
        this.children = (IBoundNode[])children.clone();
    }

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        VarArgsInfo varArgsInfo = new EqualTypesVarArgsBuilder(this.argumentsTypes).build();
        IBoundNode result = this.getVarArgsMethodNode(node, bindingContext, varArgsInfo);
        if (result == null) {
            varArgsInfo = new CastableTypesVarArgsBuilder(this.argumentsTypes, (ICastFactory)bindingContext).build();
            result = this.getVarArgsMethodNode(node, bindingContext, varArgsInfo);
        }
        return result;
    }

    private IBoundNode getVarArgsMethodNode(ISyntaxNode node, IBindingContext bindingContext, VarArgsInfo varArgsInfo) {
        IMethodCaller methodWithLastArrayArgument = bindingContext.findMethodCaller("org.openl.this", this.methodName, varArgsInfo.getModifiedMethodArguments());
        if (methodWithLastArrayArgument == null) {
            return null;
        }
        Class componentVarArgClass = varArgsInfo.getVarArgClass().getInstanceClass();
        return new VariableArgumentsMethodBoundNode(node, this.children, methodWithLastArrayArgument, varArgsInfo.getFirstVarArgIndex(), componentVarArgClass);
    }

    protected static class CastableTypesVarArgsBuilder
    extends VarArgsBuilder {
        private final ICastFactory castFactory;

        protected CastableTypesVarArgsBuilder(IOpenClass[] argumentsTypes, ICastFactory castFactory) {
            super(argumentsTypes);
            this.castFactory = castFactory;
        }

        @Override
        protected boolean ensureThatTypeIsVarArg(IOpenClass type) {
            IOpenCast cast = this.castFactory.getCast(type, this.varArgClass);
            if (cast == null || !cast.isImplicit()) {
                cast = this.castFactory.getCast(this.varArgClass, type);
                if (cast == null || !cast.isImplicit()) {
                    return false;
                }
                this.varArgClass = type;
            }
            return true;
        }
    }

    protected static class EqualTypesVarArgsBuilder
    extends VarArgsBuilder {
        protected EqualTypesVarArgsBuilder(IOpenClass[] argumentsTypes) {
            super(argumentsTypes);
        }

        @Override
        protected boolean ensureThatTypeIsVarArg(IOpenClass type) {
            return this.varArgClass.equals(type);
        }
    }

    protected static abstract class VarArgsBuilder {
        private final IOpenClass[] argumentsTypes;
        protected int firstVarArgIndex;
        protected IOpenClass varArgClass;
        protected IOpenClass[] modifiedMethodArguments;

        protected VarArgsBuilder(IOpenClass[] argumentsTypes) {
            this.argumentsTypes = argumentsTypes;
        }

        public VarArgsInfo build() {
            int numberOfAllArguments = this.argumentsTypes.length;
            this.firstVarArgIndex = numberOfAllArguments - 1;
            this.varArgClass = this.argumentsTypes[numberOfAllArguments - 1];
            if (this.argumentsTypes.length >= 1) {
                int j = numberOfAllArguments - 2;
                while (j >= 0 && this.ensureThatTypeIsVarArg(this.argumentsTypes[j])) {
                    this.firstVarArgIndex = j--;
                }
            }
            ArrayList<IOpenClass> argumentsTypesSequence = new ArrayList<IOpenClass>();
            if (this.firstVarArgIndex > 0) {
                for (int i = 0; i < this.firstVarArgIndex; ++i) {
                    argumentsTypesSequence.add(this.argumentsTypes[i]);
                }
            }
            argumentsTypesSequence.add(this.varArgClass.getAggregateInfo().getIndexedAggregateType(this.varArgClass, 1));
            this.modifiedMethodArguments = argumentsTypesSequence.toArray(new IOpenClass[argumentsTypesSequence.size()]);
            return this.createVarArgsInfo();
        }

        protected abstract boolean ensureThatTypeIsVarArg(IOpenClass var1);

        private VarArgsInfo createVarArgsInfo() {
            return new VarArgsInfo(){

                @Override
                public int getFirstVarArgIndex() {
                    return VarArgsBuilder.this.firstVarArgIndex;
                }

                @Override
                public IOpenClass[] getModifiedMethodArguments() {
                    return VarArgsBuilder.this.modifiedMethodArguments;
                }

                @Override
                public IOpenClass getVarArgClass() {
                    return VarArgsBuilder.this.varArgClass;
                }
            };
        }
    }

    protected static interface VarArgsInfo {
        public int getFirstVarArgIndex();

        public IOpenClass[] getModifiedMethodArguments();

        public IOpenClass getVarArgClass();
    }
}

