/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.DozerBeanMapper;
import org.dozer.DozerEventListener;
import org.dozer.FieldMappingCondition;
import org.dozer.MappingContext;
import org.dozer.MappingException;
import org.openl.rules.mapping.TypeResolver;
import org.openl.rules.mapping.definition.BeanMap;
import org.openl.rules.mapping.definition.BeanMapConfiguration;
import org.openl.rules.mapping.definition.Configuration;
import org.openl.rules.mapping.definition.ConverterDescriptor;
import org.openl.rules.mapping.exception.RulesMappingException;
import org.openl.rules.mapping.loader.RulesMappingsLoader;
import org.openl.rules.mapping.loader.dozer.DozerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MappingProcessor.class);
    private RulesMappingsLoader mappingsLoader;
    private DozerBeanMapper beanMapper;
    private DozerBuilder dozerBuilder = new DozerBuilder();
    private Map<String, CustomConverter> customConvertersWithId;
    private Map<String, FieldMappingCondition> conditionsWithId;
    private Map<String, BeanFactory> factories;
    private List<DozerEventListener> eventListeners;

    public MappingProcessor(Class<?> instanceClass, Object instance, TypeResolver typeResolver, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId, Map<String, BeanFactory> factories) {
        this.mappingsLoader = new RulesMappingsLoader(instanceClass, instance, typeResolver);
        this.customConvertersWithId = customConvertersWithId;
        this.conditionsWithId = conditionsWithId;
        this.factories = factories;
        this.init();
    }

    public MappingProcessor(Class<?> instanceClass, Object instance, TypeResolver typeResolver, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId, Map<String, BeanFactory> factories, List<DozerEventListener> eventListeners) {
        this.mappingsLoader = new RulesMappingsLoader(instanceClass, instance, typeResolver);
        this.customConvertersWithId = customConvertersWithId;
        this.conditionsWithId = conditionsWithId;
        this.factories = factories;
        this.eventListeners = eventListeners;
        this.init();
    }

    private void init() {
        this.dozerBuilder.mappingBuilder().customConvertersWithId(this.customConvertersWithId);
        this.dozerBuilder.mappingBuilder().conditionsWithId(this.conditionsWithId);
        this.dozerBuilder.mappingBuilder().eventListeners(this.eventListeners);
        Collection<ConverterDescriptor> defaultConverters = this.mappingsLoader.loadDefaultConverters();
        for (ConverterDescriptor converter : defaultConverters) {
            this.dozerBuilder.configBuilder().defaultConverter(converter);
        }
        if (LOG.isDebugEnabled()) {
            Collection defaultConverterLogEntries = CollectionUtils.collect(defaultConverters, (Transformer)new Transformer(){

                public String transform(Object arg) {
                    ConverterDescriptor descriptor = (ConverterDescriptor)arg;
                    return descriptor.getConverterId();
                }
            });
            LOG.debug("Default converters:\n" + StringUtils.join((Collection)defaultConverterLogEntries, (String)"\n"));
            LOG.debug("External converters: " + StringUtils.join(this.customConvertersWithId == null ? new ArrayList(0) : this.customConvertersWithId.keySet(), (String)", "));
            LOG.debug("External conditions: " + StringUtils.join(this.conditionsWithId == null ? new ArrayList(0) : this.conditionsWithId.keySet(), (String)", "));
        }
        Configuration globalConfiguration = this.mappingsLoader.loadConfiguration();
        this.dozerBuilder.configBuilder().dateFormat(globalConfiguration.getDateFormat());
        this.dozerBuilder.configBuilder().wildcard(globalConfiguration.isWildcard());
        this.dozerBuilder.configBuilder().trimStrings(globalConfiguration.isTrimStrings());
        this.dozerBuilder.configBuilder().mapNulls(globalConfiguration.isMapNulls());
        this.dozerBuilder.configBuilder().mapEmptyStrings(globalConfiguration.isMapEmptyStrings());
        this.dozerBuilder.configBuilder().requiredFields(globalConfiguration.isRequiredFields());
        this.dozerBuilder.configBuilder().beanFactory(globalConfiguration.getBeanFactory());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Global configuration: dateFormat=%s, wildcard=%s, trimStrings=%s, mapNulls=%s, mapEmptyStrings=%s, requiredFields=%s, beanFactory=%s", globalConfiguration.getDateFormat(), globalConfiguration.isWildcard(), globalConfiguration.isTrimStrings(), globalConfiguration.isMapNulls(), globalConfiguration.isMapEmptyStrings(), globalConfiguration.isRequiredFields(), globalConfiguration.getBeanFactory()));
        }
        Map<String, BeanMapConfiguration> mappingConfigurations = this.mappingsLoader.loadBeanMapConfiguraitons(globalConfiguration);
        if (LOG.isDebugEnabled()) {
            Collection beanConfigLogEntries = CollectionUtils.collect(mappingConfigurations.values(), (Transformer)new Transformer(){

                public String transform(Object arg) {
                    BeanMapConfiguration conf = (BeanMapConfiguration)arg;
                    return String.format("[classA=%s, classB=%s, classABeanFactory=%s, classBBeanFactory=%s, mapNulls=%s, mapEmptyStrings=%s, trimStrings=%s, requiredFields=%s, wildcard=%s, dateFormat=%s]", conf.getClassA(), conf.getClassB(), conf.getClassABeanFactory(), conf.getClassBBeanFactory(), conf.isMapNulls(), conf.isMapEmptyStrings(), conf.isTrimStrings(), conf.isRequiredFields(), conf.isWildcard(), conf.getDateFormat());
                }
            });
            LOG.debug("Bean level configurations:\n" + StringUtils.join((Collection)beanConfigLogEntries, (String)"\n"));
        }
        Collection<BeanMap> mappings = this.mappingsLoader.loadMappings(mappingConfigurations, globalConfiguration);
        for (BeanMap mapping : mappings) {
            this.dozerBuilder.mappingBuilder().mapping(mapping);
        }
        this.beanMapper = this.dozerBuilder.buildMapper();
        if (this.factories != null) {
            this.beanMapper.setFactories(this.factories);
        }
    }

    public void map(Object source, Object destination) {
        try {
            this.beanMapper.map(source, destination);
        }
        catch (MappingException e) {
            throw new RulesMappingException(e);
        }
    }

    public <T> T map(Object source, Class<T> destination) {
        try {
            return (T)this.beanMapper.map(source, destination);
        }
        catch (MappingException e) {
            throw new RulesMappingException(e);
        }
    }

    public void map(Object source, Object destination, MappingContext context) {
        try {
            this.beanMapper.map(source, destination, context);
        }
        catch (MappingException e) {
            throw new RulesMappingException(e);
        }
    }

    public <T> T map(Object source, Class<T> destination, MappingContext context) {
        try {
            return (T)this.beanMapper.map(source, destination, context);
        }
        catch (MappingException e) {
            throw new RulesMappingException(e);
        }
    }
}

